
<?php $__env->startSection('title'); ?>
    Pontos
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Meus Pontos','subtitle' => 'Lista de Pontos']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Meus Pontos','subtitle' => 'Lista de Pontos']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <?php if(session('message')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?>

    <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4 mb-4">
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-success text-success bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0"><?php echo e($pointsThisMonth); ?></h4>
                            <p class="mb-0">Pontos Ganhos No Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-danger text-danger bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0"><?php echo e($pointsThisYear); ?></h4>
                            <p class="mb-0">Pontos Ganhos No Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-info text-info bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ <?php echo e(number_format($salesThisMonth, 2, ',', '.')); ?></h4>
                            <p class="mb-0">Valor em Vendas no Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-orange-light text-orange bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ <?php echo e(number_format($salesThisYear, 2, ',', '.')); ?></h4>
                            <p class="mb-0">Valor em Vendas no Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->

    <!-- Formulário de Filtros -->
<form method="GET" action="<?php echo e(route('architect.points.index')); ?>" class="d-flex align-items-end gap-2 flex-wrap">
    <div>
        <label for="start_date" class="form-label">Data Inicial</label>
        <input type="date" name="start_date" id="start_date" value="<?php echo e(request('start_date')); ?>" class="form-control">
    </div>
    <div>
        <label for="end_date" class="form-label">Data Final</label>
        <input type="date" name="end_date" id="end_date" value="<?php echo e(request('end_date')); ?>" class="form-control">
    </div>
    <div>
        <label for="store_id" class="form-label">Loja</label>
        <select name="store_id" id="store_id" class="form-select">
            <option value="">Todas as Lojas</option>
            <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($store->id); ?>" <?php echo e(request('store_id') == $store->id ? 'selected' : ''); ?>><?php echo e($store->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div>
        <button type="submit" class="btn btn-primary">Filtrar</button>
    </div>
</form>

<!-- Filtros Ativos -->
<div class="mb-4">
    <?php if(request('start_date')): ?>
        <span class="badge bg-info text-dark">
            Data Inicial: <?php echo e(request('start_date')); ?>

            <a href="<?php echo e(route('architect.points.index', array_merge(request()->except('start_date'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
        </span>
    <?php endif; ?>
    <?php if(request('end_date')): ?>
        <span class="badge bg-info text-dark">
            Data Final: <?php echo e(request('end_date')); ?>

            <a href="<?php echo e(route('architect.points.index', array_merge(request()->except('end_date'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
        </span>
    <?php endif; ?>
    <?php if(request('store_id')): ?>
        <span class="badge bg-info text-dark">
            Loja: <?php echo e($stores->find(request('store_id'))->name); ?>

            <a href="<?php echo e(route('architect.points.index', array_merge(request()->except('store_id'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
        </span>
    <?php endif; ?>
</div>

<!-- Tabela de Pontos -->
<div class="card mt-4">
    <div class="card-body">
        <div class="customer-table">
            <div class="table-responsive white-space-nowrap">
                <table class="table mb-0 table-dark table-striped align-middle">
                    <thead>
                        <tr>
                            <th>Pontos</th>
                            <th>Valor da Venda</th>
                            <th>Nome do Cliente</th>
                            <th>Loja</th>
                            <th>Descrição</th>
                            <th>Data</th>
                            <th>Vendedor</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(number_format($point->points, 0, ',', '.')); ?></td>
                                <td><?php echo e('R$ ' . number_format($point->sale_value, 2, ',', '.')); ?></td>
                                <td><?php echo e($point->customer_name); ?></td>
                                <td><?php echo e($point->store->name ?? 'Loja não encontrada'); ?></td>
                                <td><?php echo e($point->description); ?></td>
                                <td><?php echo e($point->created_at->format('d/m/Y - H:i:s')); ?></td>
                                <td><?php echo e($point->admin->name); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot class="rodape-tabela">
                        <tr>
                            <th>Total: <?php echo e(number_format($totalPoints, 0, ',', '.')); ?></th>
                            <th>Total: <?php echo e('R$ ' . number_format($totalSales, 2, ',', '.')); ?></th>
                            <th colspan="5"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <div class="mt-4">
                <?php echo e($points->appends(request()->query())->links('pagination::bootstrap-4')); ?>

            </div>
        </div>
    </div>
</div>


    


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/architect/points/index.blade.php ENDPATH**/ ?>