
<?php $__env->startSection('title'); ?>
    Detalhes do Arquiteto
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Detalhes do Arquiteto','subtitle' => ''.e($architect->name).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Detalhes do Arquiteto','subtitle' => ''.e($architect->name).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <?php if(session('success')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="d-flex justify-content-end mb-3">
        <a href="<?php echo e(route('admin.architects.assignPoints', $architect->id)); ?>" class="btn btn-success me-2">Atribuir Pontos</a>
        <a href="<?php echo e(route('admin.architects.edit', $architect->id)); ?>" class="btn btn-warning me-2">Editar Arquiteto</a>
        <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">Deletar Arquiteto</button>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <h5>Informações Pessoais</h5>
            <p><strong>Nome:</strong> <?php echo e($architect->name); ?></p>
            <p><strong>Email:</strong> <?php echo e($architect->email); ?></p>
            <p><strong>Telefone:</strong> <?php echo e($architect->architectProfile->phone ?? 'N/A'); ?></p>
            <p><strong>Data de Nascimento:</strong> <?php if($architect->architectProfile && $architect->architectProfile->birth_date): ?>
                <?php echo e(\Carbon\Carbon::parse($architect->architectProfile->birth_date)->format('d/m/Y')); ?>

            <?php else: ?>
                N/A
            <?php endif; ?></p>
        </div>
    </div>

    <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-success text-success bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0"><?php echo e($pointsThisMonth); ?></h4>
                            <p class="mb-0">Pontos Ganhos No Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-danger text-danger bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0"><?php echo e($pointsThisYear); ?></h4>
                            <p class="mb-0">Pontos Ganhos No Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-info text-info bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ <?php echo e(number_format($salesThisMonth, 2, ',', '.')); ?></h4>
                            <p class="mb-0">Valor em Vendas no Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-orange-light text-orange bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ <?php echo e(number_format($salesThisYear, 2, ',', '.')); ?></h4>
                            <p class="mb-0">Valor em Vendas no Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->
    
    <div class="card mt-4">
        <div class="card-body">
            <h5>Pontos Atribuídos</h5>
            <table class="table table-dark table-striped">
                <thead>
                    <tr>
                        <th>Pontos</th>
                        <th>Valor da Venda</th>
                        <th>Nome do Cliente</th>
                        <th>Descrição</th>
                        <th>Data</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $architect->points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($point->points); ?></td>
                            <td>R$ <?php echo e(number_format($point->sale_value, 2, ',', '.')); ?></td>
                            <td><?php echo e($point->customer_name); ?></td>
                            <td><?php echo e($point->description); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($point->created_at)->format('d/m/Y')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este arquiteto?
                </div>
                <div class="modal-footer">
                    <form method="POST" action="<?php echo e(route('admin.architects.destroy', $architect->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <!--plugins-->
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/renovarp/public_html/arccanovo/resources/views/admin/architects/show.blade.php ENDPATH**/ ?>