
<?php $__env->startSection('title'); ?>
    Editar Ponto
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Pontos','subtitle' => 'Editar Ponto']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pontos','subtitle' => 'Editar Ponto']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <div class="card mt-4">
        <div class="card-body">
            <form action="<?php echo e(route('admin.points.update', $point->id)); ?>" method="POST" id="point-form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="mb-4">
                    <label for="architect_id" class="form-label">Arquiteto</label>
                    <select name="architect_id" id="architect_id" class="form-select" required>
                        <?php $__currentLoopData = $architects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $architect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($architect->id); ?>" <?php echo e($point->architect_id == $architect->id ? 'selected' : ''); ?>>
                                <?php echo e($architect->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-4">
                    <label for="scoring_rule_id" class="form-label">Regra de Pontuação</label>
                    <select name="scoring_rule_id" id="scoring_rule_id" class="form-select" required>
                        <?php $__currentLoopData = $scoringRules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($rule->id); ?>" data-amount="<?php echo e($rule->amount_spent_per_point); ?>"
                                <?php echo e($point->scoring_rule_id == $rule->id ? 'selected' : ''); ?>>
                                <?php echo e($rule->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-4">
                    <label for="store_id" class="form-label">Loja</label>
                    <select name="store_id" id="store_id" class="form-select" required>
                        <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($store->id); ?>" <?php echo e($point->store_id == $store->id ? 'selected' : ''); ?>>
                                <?php echo e($store->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-4">
                    <label for="sale_value" class="form-label">Valor da Venda</label>
                    <div class="input-group">
                        <span class="input-group-text">R$</span>
                        <input type="text" name="sale_value" id="sale_value" value="<?php echo e(number_format($point->sale_value, 2, ',', '.')); ?>" class="form-control" required>
                    </div>
                </div>
                <div class="mb-4">
                    <label for="calculated_points" class="form-label">Pontos Calculados</label>
                    <input type="text" id="calculated_points" class="form-control" value="<?php echo e($point->points); ?>" readonly>
                </div>
                <div class="mb-4">
                    <label for="customer_name" class="form-label">Nome do Cliente</label>
                    <input type="text" name="customer_name" id="customer_name" value="<?php echo e($point->customer_name); ?>" class="form-control" required>
                </div>
                <div class="mb-4">
                    <label for="description" class="form-label">Descrição</label>
                    <textarea name="description" id="description" class="form-control" required><?php echo e($point->description); ?></textarea>
                </div>
                <button type="submit" class="btn btn-primary">Atualizar Ponto</button>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const saleValueInput = document.getElementById('sale_value');
            const scoringRuleSelect = document.getElementById('scoring_rule_id');
            const calculatedPointsInput = document.getElementById('calculated_points');

            function calculatePoints() {
                const saleValue = parseFloat(saleValueInput.value.replace(/\./g, '').replace(',', '.'));
                const amountSpentPerPoint = parseFloat(scoringRuleSelect.options[scoringRuleSelect.selectedIndex].getAttribute('data-amount'));
                
                if (!isNaN(saleValue) && !isNaN(amountSpentPerPoint)) {
                    const points = Math.floor(saleValue / amountSpentPerPoint);
                    calculatedPointsInput.value = points;
                } else {
                    calculatedPointsInput.value = '';
                }
            }

            saleValueInput.addEventListener('input', function () {
                let value = saleValueInput.value.replace(/\D/g, '');
                value = (value / 100).toFixed(2) + '';
                value = value.replace(".", ",");
                value = value.replace(/(\d)(?=(\d{3})+\,)/g, "$1.");
                saleValueInput.value = value;
                calculatePoints();
            });

            scoringRuleSelect.addEventListener('change', calculatePoints);

            document.getElementById('point-form').addEventListener('submit', function (event) {
                const saleValue = saleValueInput.value.replace(/\./g, '').replace(',', '.');
                saleValueInput.value = saleValue;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/admin/points/edit.blade.php ENDPATH**/ ?>