
<?php $__env->startSection('title'); ?>
    Pontos
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Pontos','subtitle' => 'Lista de Pontos']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pontos','subtitle' => 'Lista de Pontos']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <?php if(session('message')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <form method="GET" action="<?php echo e(route('admin.points.index')); ?>" class="d-flex align-items-end gap-2 flex-wrap">
            <div>
                <label for="architect_id" class="form-label">Arquiteto</label>
                <select name="architect_id" id="architect_id" class="form-select">
                    <option value="">Todos os Arquitetos</option>
                    <?php $__currentLoopData = $architects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $architect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($architect->id); ?>" <?php echo e(request('architect_id') == $architect->id ? 'selected' : ''); ?>>
                            <?php echo e($architect->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            
            <!-- Novo Filtro por Loja -->
            <div>
                <label for="store_id" class="form-label">Loja</label>
                <select name="store_id" id="store_id" class="form-select">
                    <option value="">Todas as Lojas</option>
                    <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($store->id); ?>" <?php echo e(request('store_id') == $store->id ? 'selected' : ''); ?>>
                            <?php echo e($store->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        
            <div>
                <label for="start_date" class="form-label">Data Inicial</label>
                <input type="date" name="start_date" id="start_date" value="<?php echo e(request('start_date')); ?>" class="form-control">
            </div>
            <div>
                <label for="end_date" class="form-label">Data Final</label>
                <input type="date" name="end_date" id="end_date" value="<?php echo e(request('end_date')); ?>" class="form-control">
            </div>
            <div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
        </form>        
        <a href="<?php echo e(route('admin.points.create')); ?>" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Atribuir Pontos</a>
    </div>

    <!-- Filtros Ativos -->
    <!-- Filtros Ativos -->
    <div class="mb-4">
        <?php if(request('architect_id')): ?>
            <span class="badge bg-info text-dark">
                Arquiteto: <?php echo e($architects->find(request('architect_id'))->name); ?>

                <a href="<?php echo e(route('admin.points.index', array_merge(request()->except('architect_id'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>

        <?php if(request('store_id')): ?>
            <span class="badge bg-info text-dark">
                Loja: <?php echo e($stores->find(request('store_id'))->name); ?>

                <a href="<?php echo e(route('admin.points.index', array_merge(request()->except('store_id'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>

        <?php if(request('start_date')): ?>
            <span class="badge bg-info text-dark">
                Data Inicial: <?php echo e(request('start_date')); ?>

                <a href="<?php echo e(route('admin.points.index', array_merge(request()->except('start_date'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>

        <?php if(request('end_date')): ?>
            <span class="badge bg-info text-dark">
                Data Final: <?php echo e(request('end_date')); ?>

                <a href="<?php echo e(route('admin.points.index', array_merge(request()->except('end_date'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>
    </div>


    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Arquiteto</th>
                                <th>Pontos</th>
                                <th>Valor da Venda</th>
                                <th>Regra de Pontuação</th> <!-- Nova coluna -->

                                <th>Nome do Cliente</th>
                                <th>Loja</th> <!-- Nova Coluna de Loja -->
                                <th>Data</th>
                                <th class="text-right">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($point->architect->name); ?></td>
                                    <td><?php echo e(number_format($point->points, 0, ',', '.')); ?></td>
                                    <td><?php echo e('R$ ' . number_format($point->sale_value, 2, ',', '.')); ?></td>
                                    <td><?php echo e($point->scoring_rule_name); ?></td> <!-- Exibe a regra de pontuação -->
                                    <td><?php echo e($point->customer_name); ?></td>
                                    <td><?php echo e($point->store->name ?? 'N/A'); ?></td> <!-- Exibição da loja -->
                                    <td><?php echo e($point->created_at->format('d/m/Y')); ?></td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('admin.points.edit', $point->id)); ?>" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="<?php echo e(route('admin.points.destroy', $point->id)); ?>">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="rodape-tabela">
                                <th>Total</th>
                                <th><?php echo e(number_format($totalPoints, 0, ',', '.')); ?></th>
                                <th><?php echo e('R$ ' . number_format($totalSaleValue, 2, ',', '.')); ?></th>
                                <th colspan="7"></th>
                            </tr>
                        </tfoot>
                    </table>                    
                </div>
                <div class="mt-4">
                    <p><strong>Total de registros:</strong> <?php echo e($points->total()); ?></p> <!-- Exibe o total de registros -->
                    <?php echo e($points->appends(request()->query())->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este ponto?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/admin/points/index.blade.php ENDPATH**/ ?>