

<?php $__env->startSection('title', $ranking->name); ?>
<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(URL::asset('build/css/extra-icons.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <!-- Seção comum para ambos os tipos de ranking -->
        <div class="card mb-4">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <img src="<?php echo e($ranking->image ? asset('storage/'.$ranking->image->path) : asset('images/default-image.jpg')); ?>" class="img-fluid rounded" alt="<?php echo e($ranking->name); ?>">
                </div>
                <div class="col-md-6">
                    <h1><?php echo e($ranking->name); ?></h1>
                    <p><i class="lni lni-calendar"></i> <?php echo e($ranking->start_date->format('d/m/Y')); ?> á <?php echo e($ranking->end_date->format('d/m/Y')); ?></p>
                    <?php echo $ranking->description; ?>

                    <p>Status: <?php echo e($ranking->is_active ? 'Ativo' : 'Inativo'); ?></p>
                    <p>Criado por: <?php echo e($admin ? $admin->name : 'Admin não encontrado'); ?></p>
                    <?php if($ranking->type === 'position'): ?>
                        <p>Sua posição nesse ranking: #<?php echo e($userPosition ?? 'N/A'); ?></p>
                    <?php elseif($ranking->type === 'goal'): ?>
                        <p>Você tem <b><?php echo e(number_format($userPoints, 0, ',', '.')); ?></b> pontos neste ranking</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <?php if($ranking->type === 'goal'): ?>
            <!-- Layout para o tipo por meta -->
            <div class="row">
                <?php $__currentLoopData = $ranking->rewards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 mb-4">
                        <div class="card">
                            <img src="<?php echo e(asset('storage/'.$reward->image->path)); ?>" class="card-img-top" alt="<?php echo e($reward->name); ?>">
                            <div class="card-body">
                                <h5 class="card-title"><?php echo e($reward->name); ?></h5>
                                <p class="card-text">Pontos Necessários: <?php echo e($reward->points_required); ?></p>
                                <?php if(in_array($reward, $qualifiedRewards)): ?>
                                    <p class="text-success">Você atingiu os pontos necessários!</p>
                                <?php else: ?>
                                    <p class="text-danger">Você ainda não atingiu os pontos necessários.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php elseif($ranking->type === 'position'): ?>
            <!-- Layout para o tipo por posição -->
            <div class="row">
                <div class="col-md-12">
                    <h2>Prêmios</h2>
                    <div class="row">
                        <?php $qualified = false; ?>
                        <?php $__currentLoopData = $ranking->rewards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="row g-0 align-items-center">
                                        <div class="col-md-4">
                                            <img src="<?php echo e(asset('storage/'.$reward->image->path)); ?>" class="img-fluid rounded-start" alt="<?php echo e($reward->name); ?>">
                                        </div>
                                        <div class="col-md-8">
                                            <div class="card-body">
                                                <h5 class="card-title"><?php echo e($reward->name); ?></h5>
                                                <p class="card-text">Posição Necessária: <?php echo e($reward->position_required); ?></p>
                                                <?php if($userPosition <= $reward->position_required && !$qualified): ?>
                                                    <h6>Você está se qualificando para este prêmio!</h6>
                                                    <?php $qualified = true; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/architect/rankings/show.blade.php ENDPATH**/ ?>