
<?php $__env->startSection('title'); ?>
    Arquitetos
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Arquitetos','subtitle' => 'Lista de Arquitetos']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Arquitetos','subtitle' => 'Lista de Arquitetos']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <?php if(session('message')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?>

    <div class="d-flex align-items-center gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <a href="<?php echo e(route('admin.architects.index')); ?>">
            <span class="me-1">Arquitetos</span>
            <span class="text-secondary">(<?php echo e($totalArchitects); ?>)</span>
        </a>
    </div>

    <div class="row g-3 justify-content-between">
        <div class="col-auto">
            <div class="position-relative">
                <form method="GET" action="<?php echo e(route('admin.architects.index')); ?>" class="d-flex align-items-center">
                    <input class="form-control px-5" type="search" name="search" placeholder="Buscar Arquitetos" value="<?php echo e(request('search')); ?>">
                    <span class="material-icons-outlined position-absolute ms-3 translate-middle-y start-0 top-50 fs-5">search</span>
                </form>
            </div>
        </div>
        <div class="col-auto">
            <div class="d-flex align-items-center gap-2 justify-content-lg-end">
                <a href="<?php echo e(route('admin.architects.create')); ?>" class="btn btn-primary px-4"><i class="bi bi-plus-lg me-2"></i>Criar Novo Arquiteto</a>
            </div>
        </div>
    </div><!--end row-->

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Telefone</th>
                                <th>Data de Nascimento</th>
                                <th class="text-end">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $architects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $architect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($architect->name); ?></td>
                                    <td><?php echo e($architect->email); ?></td>
                                    
                                    <td><?php echo e(optional($architect->architectProfile)->phone); ?></td>
                                    <td>
                                        <?php if($architect->architectProfile && $architect->architectProfile->birth_date): ?>
                                            <?php echo e(\Carbon\Carbon::parse($architect->architectProfile->birth_date)->format('d/m/Y')); ?>

                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end">
                                        <a href="<?php echo e(route('admin.architects.show', $architect->id)); ?>" class="btn btn-info btn-sm">Ver Arquiteto</a>
                                        <a href="<?php echo e(route('admin.architects.assignPoints', $architect->id)); ?>" class="btn btn-success btn-sm">Atribuir Pontos</a>
                                    </td>                                    
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    <?php echo e($architects->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!--plugins-->
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/admin/architects/index.blade.php ENDPATH**/ ?>