
<?php $__env->startSection('title'); ?>
    Gerenciar Imagens
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Imagens','subtitle' => 'Gerenciar Imagens']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Imagens','subtitle' => 'Gerenciar Imagens']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <div class="card mt-4">
        <div class="card-body">
            <div class="mb-4">
                <h3 class="text-lg font-medium text-gray-700">Imagens</h3>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th scope="col" class="text-center">Thumbnail</th>
                            <th scope="col">Caminho</th>
                            <th scope="col" class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center">
                                    <img src="<?php echo e(Storage::url($image->path)); ?>" alt="<?php echo e($image->filename); ?>" class="img-thumbnail" style="width: 100px; height: 100px;">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="text" value="<?php echo e(Storage::url($image->path)); ?>" class="form-control" readonly>
                                        <button class="btn btn-primary" onclick="copyToClipboard('<?php echo e(Storage::url($image->path)); ?>')">Copiar</button>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal" data-image-id="<?php echo e($image->id); ?>">Excluir</button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                <?php echo e($images->links('pagination::bootstrap-4')); ?>

            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir esta imagem?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteButton">Excluir</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function copyToClipboard(url) {
            navigator.clipboard.writeText(url).then(function() {
                alert('URL copiado para a área de transferência.');
            }, function(err) {
                alert('Erro ao copiar o URL: ', err);
            });
        }

        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            var confirmDeleteButton = document.getElementById('confirmDeleteButton');
            var imageIdToDelete;

            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                imageIdToDelete = button.getAttribute('data-image-id');
            });

            confirmDeleteButton.addEventListener('click', function () {
                if (imageIdToDelete) {
                    fetch(`/admin/images/${imageIdToDelete}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert('Erro ao excluir a imagem.');
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/admin/images/index.blade.php ENDPATH**/ ?>