
<?php $__env->startSection('title'); ?>
    Rankings
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Rankings','subtitle' => 'Lista de Rankings']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Rankings','subtitle' => 'Lista de Rankings']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <?php if(session('message')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <form method="GET" action="<?php echo e(route('admin.rankings.index')); ?>" class="d-flex align-items-end gap-2 flex-wrap">
            <div>
                <label for="start_date" class="form-label">Data Inicial</label>
                <input type="date" name="start_date" id="start_date" value="<?php echo e(request('start_date')); ?>" class="form-control">
            </div>
            <div>
                <label for="end_date" class="form-label">Data Final</label>
                <input type="date" name="end_date" id="end_date" value="<?php echo e(request('end_date')); ?>" class="form-control">
            </div>
            <div>
                <label for="is_active" class="form-label">Ativo</label>
                <select name="is_active" id="is_active" class="form-select">
                    <option value="">Todos</option>
                    <option value="1" <?php echo e(request('is_active') == 1 ? 'selected' : ''); ?>>Sim</option>
                    <option value="0" <?php echo e(request('is_active') == 0 ? 'selected' : ''); ?>>Não</option>
                </select>
            </div>
            <div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
        </form>
        <a href="<?php echo e(route('admin.rankings.create')); ?>" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Criar Ranking</a>
    </div>

    <!-- Filtros Ativos -->
    <div class="mb-4">
        <?php if(request('start_date')): ?>
            <span class="badge bg-info text-dark">
                Data Inicial: <?php echo e(request('start_date')); ?>

                <a href="<?php echo e(route('admin.rankings.index', array_merge(request()->except('start_date'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>
        <?php if(request('end_date')): ?>
            <span class="badge bg-info text-dark">
                Data Final: <?php echo e(request('end_date')); ?>

                <a href="<?php echo e(route('admin.rankings.index', array_merge(request()->except('end_date'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>
        <?php if(request('is_active') !== null && request('is_active') !== ''): ?>
            <span class="badge bg-info text-dark">
                Ativo: <?php echo e(request('is_active') == 1 ? 'Sim' : 'Não'); ?>

                <a href="<?php echo e(route('admin.rankings.index', array_merge(request()->except('is_active'), ['page' => 1]))); ?>" class="text-dark ms-1">&times;</a>
            </span>
        <?php endif; ?>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Data de Início</th>
                                <th>Data de Fim</th>
                                <th>Tipo</th> <!-- Nova coluna de tipo -->
                                <th>Ativo</th>
                                <th class="text-end">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ranking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($ranking->name); ?></td>
                                    <td><?php echo e($ranking->start_date->format('d/m/Y')); ?></td>
                                    <td><?php echo e($ranking->end_date->format('d/m/Y')); ?></td>
                                    <td><?php echo e($ranking->type === 'goal' ? 'Por Meta' : 'Por Posição'); ?></td> <!-- Exibe o tipo de ranking -->
                                    <td><?php echo e($ranking->is_active ? 'Sim' : 'Não'); ?></td>
                                    <td class="text-end">
                                        <a href="<?php echo e(route('admin.rankings.show', $ranking->id)); ?>" class="btn btn-info btn-sm">Ver Ranking</a> <!-- Novo botão para visualizar -->
                                        <a href="<?php echo e(route('admin.rankings.edit', $ranking->id)); ?>" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="<?php echo e(route('admin.rankings.destroy', $ranking->id)); ?>">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    <?php echo e($rankings->appends(request()->query())->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este ranking?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/renovarp/public_html/arccanovo/resources/views/admin/rankings/index.blade.php ENDPATH**/ ?>