
<?php $__env->startSection('title'); ?>
    Lojas
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(URL::asset('build/css/extra-icons.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <?php if (isset($component)) { $__componentOriginal8b54caccbdedc8030792c13949386bbd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8b54caccbdedc8030792c13949386bbd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-title','data' => ['title' => 'Lojas','subtitle' => 'Listagem de Lojas']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-title'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Lojas','subtitle' => 'Listagem de Lojas']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $attributes = $__attributesOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__attributesOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8b54caccbdedc8030792c13949386bbd)): ?>
<?php $component = $__componentOriginal8b54caccbdedc8030792c13949386bbd; ?>
<?php unset($__componentOriginal8b54caccbdedc8030792c13949386bbd); ?>
<?php endif; ?>

    <div class="row g-4">
        <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 col-xl-4 mt-5">
                <div class="card mb-0">
                    <div class="card-body">
                        <div class="position-relative">
                            <div class="position-absolute top-100 start-50 translate-middle">
                                <img src="<?php echo e($store->image_id ? asset('storage/'.$store->image->path) : 'https://placehold.co/110x110/png'); ?>" width="100" height="100"
                                    class="rounded-circle raised borda-dourada" alt="<?php echo e($store->name); ?>">
                            </div>
                        </div>
                        <div class="text-center mt-5 pt-4">
                            <h5 class="mb-2"><?php echo e($store->name); ?></h5>
                            <?php if($store->telefone): ?>
                                <p class="mb-0 flex-stores"><i class="material-icons-outlined">phone</i> <?php echo e($store->telefone); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="d-flex align-items-center justify-content-around mt-4 text-center">
                            <ul class="lista-loja">
                                <?php if($store->rua || $store->numero || $store->bairro || $store->cidade || $store->cep || $store->estado): ?>
                                    <li class="flex-stores"><i class="lni lni-home"></i> <?php echo e($store->rua); ?>, <?php echo e($store->numero); ?>, <?php echo e($store->bairro); ?>, <?php echo e($store->cep); ?>, <?php echo e($store->cidade); ?> - <?php echo e($store->estado); ?></li>
                                <?php endif; ?>
                                <?php if($store->email): ?>
                                    <li class="flex-stores"><i class="lni lni-envelope"></i> <?php echo e($store->email); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <hr>
                        <div class="d-flex align-items-center justify-content-center gap-3">
                            <?php if($store->instagram): ?>
                                <a href="https://instagram.com/<?php echo e($store->instagram); ?>" target="_blank"
                                    class="wh-48 bg-linkedin text-white rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-instagram fs-5"></i>
                                </a>
                            <?php endif; ?>
                            <?php if($store->telefone): ?>
                                <a href="https://wa.me/55<?php echo e(preg_replace('/[^0-9]/', '', $store->telefone)); ?>" target="_blank"
                                    class="wh-48 bg-whatsapp text-white rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-whatsapp fs-5"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div><!--end row-->

    <!-- Paginação -->
    <div class="mt-4">
        <?php echo e($stores->links('pagination::bootstrap-4')); ?>

    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <!--plugins-->
    <script src="<?php echo e(URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('build/js/main.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/manager/stores/index.blade.php ENDPATH**/ ?>