<?php $__env->startSection('title'); ?>
    Registrar
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="section-authentication-cover">
        <div class="">
            <div class="row g-0">
                <div
                    class="col-12 col-xl-7 col-xxl-8 auth-cover-left align-items-center justify-content-center d-none d-xl-flex border-end bg-transparent fundo-nova-conta">

                    <div class="card rounded-0 mb-0 border-0 shadow-none bg-transparent bg-none">
                        <div class="card-body">
                            <!-- Imagem ou conteúdo da esquerda -->
                        </div>
                    </div>
                </div>

                <div class="col-12 col-xl-5 col-xxl-4 auth-cover-right align-items-center justify-content-center">
                    <div class="card rounded-0 m-3 border-0 shadow-none bg-none">
                        <div class="card-body p-sm-5">
                            <img src="<?php echo e(URL::asset('build/images/logo1.png')); ?>" class="mb-4" width="145" alt="">
                            <h4 class="fw-bold">Crie uma nova conta</h4>
                            <p class="mb-0">Insira seus dados abaixo para se registrar</p>

                            <div class="form-body mt-4">
                                <form method="POST" action="<?php echo e(route('register')); ?>" class="row g-3" id="create-architect-form">
                                    <?php echo csrf_field(); ?>

                                    <!-- Nome -->
                                    <div class="col-12">
                                        <label for="name" class="form-label">Nome <span class="text-danger">*</span></label>
                                        <input id="name" type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="name" value="<?php echo e(old('name')); ?>" required autocomplete="name" autofocus
                                               placeholder="Insira seu nome">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Email -->
                                    <div class="col-12">
                                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                        <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email"
                                               placeholder="Insira seu email">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Senha -->
                                    <div class="col-12">
                                        <label for="inputChoosePassword" class="form-label">Senha <span class="text-danger">*</span></label>
                                        <div class="input-group" id="show_hide_password">
                                            <input id="password" type="password"
                                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password"
                                                   required autocomplete="new-password" placeholder="Insira sua senha">
                                            <a href="javascript:void(0);" class="input-group-text bg-transparent"><i
                                                    class="bi bi-eye-slash-fill"></i></a>
                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <!-- Confirmação de Senha -->
                                    <div class="col-12">
                                        <label for="password-confirm" class="form-label">Confirmação de Senha <span class="text-danger">*</span></label>
                                        <div class="input-group" id="show_hide_password">
                                            <input id="password-confirm" type="password" class="form-control"
                                                   name="password_confirmation" required autocomplete="new-password"
                                                   placeholder="Insira sua senha novamente">
                                            <a href="javascript:void(0);" class="input-group-text bg-transparent"><i
                                                    class="bi bi-eye-slash-fill"></i></a>
                                        </div>
                                    </div>

                                    <!-- CPF -->
                                    <div class="col-12">
                                        <label for="cpf" class="form-label">CPF</label>
                                        <input type="text" name="cpf" class="form-control" id="cpf" value="<?php echo e(old('cpf')); ?>">
                                        <div id="cpf-invalid-feedback" class="invalid-feedback"></div>
                                    </div>

                                    <!-- CEP -->
                                    <div class="col-12">
                                        <label for="cep" class="form-label">CEP</label>
                                        <input type="text" name="cep" class="form-control" id="cep" value="<?php echo e(old('cep')); ?>">
                                    </div>

                                    <!-- Endereço -->
                                    <div class="col-12">
                                        <label for="rua" class="form-label">Rua</label>
                                        <input type="text" name="rua" class="form-control" id="rua" value="<?php echo e(old('rua')); ?>">
                                    </div>

                                    <div class="col-12">
                                        <label for="numero" class="form-label">Número</label>
                                        <input type="text" name="numero" class="form-control" id="numero" value="<?php echo e(old('numero')); ?>">
                                    </div>

                                    <div class="col-12">
                                        <label for="bairro" class="form-label">Bairro</label>
                                        <input type="text" name="bairro" class="form-control" id="bairro" value="<?php echo e(old('bairro')); ?>">
                                    </div>

                                    <div class="col-12">
                                        <label for="cidade" class="form-label">Cidade</label>
                                        <input type="text" name="cidade" class="form-control" id="cidade" value="<?php echo e(old('cidade')); ?>">
                                    </div>

                                    <div class="col-12">
                                        <label for="estado" class="form-label">Estado</label>
                                        <input type="text" name="estado" class="form-control" id="estado" value="<?php echo e(old('estado')); ?>">
                                    </div>

                                    <!-- Telefone -->
                                    <div class="col-12">
                                        <label for="phone" class="form-label">Telefone</label>
                                        <input type="text" name="phone" class="form-control" id="phone" value="<?php echo e(old('phone')); ?>">
                                    </div>

                                    <!-- Data de Nascimento -->
                                    <div class="col-12">
                                        <label for="birth_date" class="form-label">Data de Nascimento</label>
                                        <input type="date" name="birth_date" class="form-control" value="<?php echo e(old('birth_date')); ?>">
                                    </div>

                                    <!-- Botão Registrar -->
                                    <div class="col-12">
                                        <div class="d-grid">
                                            <button type="submit" class="btn btn-grd-primary">Registrar</button>
                                        </div>
                                    </div>
                                    
                                    <!-- Já tem uma conta -->
                                    <div class="col-12">
                                        <div class="text-start">
                                            <p class="mb-0">Você já tem uma conta? <a href="<?php echo e(route('login')); ?>">Acessar</a></p>
                                        </div>
                                    </div>

                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const cpfInput = document.getElementById('cpf');
            const cepInput = document.getElementById('cep');
            const phoneInput = document.getElementById('phone');
            const cpfInvalidFeedback = document.getElementById('cpf-invalid-feedback');

            // Máscaras de CPF, CEP e Telefone
            cpfInput.addEventListener('input', function () {
                cpfInput.value = cpfInput.value.replace(/\D/g, '')
                    .replace(/(\d{3})(\d)/, '$1.$2')
                    .replace(/(\d{3})(\d)/, '$1.$2')
                    .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            });

            cepInput.addEventListener('input', function () {
                cepInput.value = cepInput.value.replace(/\D/g, '').replace(/(\d{5})(\d)/, '$1-$2');
            });

            phoneInput.addEventListener('input', function () {
                phoneInput.value = phoneInput.value.replace(/\D/g, '')
                    .replace(/(\d{2})(\d)/, '($1) $2')
                    .replace(/(\d{5})(\d{1,4})$/, '$1-$2');
            });

            // Preenchimento automático do endereço com base no CEP
            cepInput.addEventListener('blur', function () {
                const cep = cepInput.value.replace(/\D/g, '');
                if (cep !== '') {
                    const validacep = /^[0-9]{8}$/;
                    if (validacep.test(cep)) {
                        fetch(`https://viacep.com.br/ws/${cep}/json/`)
                            .then(response => response.json())
                            .then(data => {
                                if (!data.erro) {
                                    document.getElementById('rua').value = data.logradouro;
                                    document.getElementById('bairro').value = data.bairro;
                                    document.getElementById('cidade').value = data.localidade;
                                    document.getElementById('estado').value = data.uf;
                                } else {
                                    alert("CEP não encontrado.");
                                }
                            })
                            .catch(error => console.error('Erro ao buscar CEP:', error));
                    } else {
                        alert("Formato de CEP inválido.");
                    }
                }
            });

            // Validação de CPF
            function validarCPF(cpf) {
                cpf = cpf.replace(/[^\d]+/g,'');
                if (cpf === '') return false;
                if (cpf.length !== 11 || /^(\d)\1+$/.test(cpf)) return false;
                let add = 0;
                for (let i = 0; i < 9; i++) add += parseInt(cpf.charAt(i)) * (10 - i);
                let rev = 11 - (add % 11);
                if (rev === 10 || rev === 11) rev = 0;
                if (rev !== parseInt(cpf.charAt(9))) return false;
                add = 0;
                for (let i = 0; i < 10; i++) add += parseInt(cpf.charAt(i)) * (11 - i);
                rev = 11 - (add % 11);
                return rev === parseInt(cpf.charAt(10));
            }

            document.getElementById('create-architect-form').addEventListener('submit', function (event) {
                const cpf = cpfInput.value;
                if (cpf && !validarCPF(cpf)) {
                    cpfInvalidFeedback.innerHTML = 'CPF inválido';
                    cpfInput.classList.add('is-invalid');
                    cpfInput.focus();
                    event.preventDefault();
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mamp-2024\arranjo-novo\resources\views/auth/register.blade.php ENDPATH**/ ?>