<?php

use App\Http\Controllers\ProfileController;

use App\Http\Controllers\Admin\ArchitectController as AdminArchitectController;
use App\Http\Controllers\Admin\ImageUploadController;
use App\Http\Controllers\Admin\RankingController as AdminRankingController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PointsController as AdminPointsController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\StoreController as AdminStoreController;
use App\Http\Controllers\Admin\ScoringRulesController;
use App\Http\Controllers\AdminRegistrationController;
use App\Http\Controllers\Architect\DashboardController as ArchitectDashboardController;
use App\Http\Controllers\Architect\PointsController as ArchitectPointsController;
use App\Http\Controllers\Architect\RankingsController as ArchitectRankingsController;

use App\Http\Controllers\Manager\ArchitectController as ManagerArchitectController;
use App\Http\Controllers\Manager\DashboardController as ManagerDashboardController;
use App\Http\Controllers\Manager\StoreController as ManagerStoreController;
use App\Http\Controllers\Manager\PointsController as ManagerPointsController;
use App\Http\Controllers\Manager\RankingController as ManagerRankingController;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('register-admin', [AdminRegistrationController::class, 'showRegistrationForm'])->name('register.admin');
Route::post('register-admin', [AdminRegistrationController::class, 'register'])->name('register.admin.submit');

Auth::routes();

Route::get('/', function () {
    if (Auth::check()) {
        if (Auth::user()->role == 'admin') {
            return redirect('/admin');
        } elseif (Auth::user()->role == 'architect') {
            return redirect('/architect');
        } elseif (Auth::user()->role == 'store_manager') {
            return redirect('/manager');
        }
    }
    return redirect('/login');
})->name('home');

// Rota global para perfil acessível por todos os usuários autenticados
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Rotas exclusivas para Arquitetos
Route::middleware(['auth', 'architect'])->prefix('architect')->name('architect.')->group(function () {
    Route::get('/', [ArchitectDashboardController::class, 'index'])->name('dashboard');
    Route::get('points', [ArchitectPointsController::class, 'index'])->name('points.index');
    Route::resource('rankings', ArchitectRankingsController::class);    
    Route::get('stores', [ManagerStoreController::class, 'index'])->name('stores.index');  // Nome correto
});

// Rotas exclusivas para Gerentes de Loja
Route::middleware(['auth', 'manager'])->prefix('manager')->name('manager.')->group(function () {
    Route::get('/', [ManagerDashboardController::class, 'index'])->name('dashboard');
    Route::resource('architects', ManagerArchitectController::class);
    Route::get('architects/{architect}/assignPoints', [ManagerPointsController::class, 'assignPoints'])->name('architects.assignPoints');
    Route::post('architects/{architect}/storePoints', [ManagerPointsController::class, 'storePoints'])->name('architects.storePoints');
    Route::resource('points', ManagerPointsController::class);
    Route::resource('rankings', ManagerRankingController::class);
    
    // Rotas específicas para stores
    Route::get('stores', [ManagerStoreController::class, 'index'])->name('stores.index');  // Nome correto
    Route::get('stores/edit', [ManagerStoreController::class, 'edit'])->name('stores.edit'); // Correção de nome
    Route::put('stores', [ManagerStoreController::class, 'update'])->name('stores.update'); // Correção de nome
    Route::post('image-upload', [ImageUploadController::class, 'upload'])->name('stores.upload'); // Geral
    Route::delete('image-upload/{image}', [ImageUploadController::class, 'destroy'])->name('stores.upload.destroy'); // Geral
    
});

// Rotas de administrador protegidas por autenticação e verificação de papel
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');

    Route::resource('users', UserController::class);
    Route::resource('points', AdminPointsController::class);
    Route::resource('rankings', AdminRankingController::class);
    Route::resource('architects', AdminArchitectController::class);
    Route::resource('stores', AdminStoreController::class);
    Route::resource('scoring-rules', ScoringRulesController::class);
    Route::get('architects/{architect}/assignPoints', [AdminPointsController::class, 'assignPoints'])->name('architects.assignPoints');
    Route::post('architects/{architect}/storePoints', [AdminPointsController::class, 'storePoints'])->name('architects.storePoints');
    Route::post('rankings/upload', [ImageUploadController::class, 'upload'])->name('rankings.upload');
    Route::get('images', [ImageUploadController::class, 'index'])->name('images.index');
    Route::delete('images/{image}', [ImageUploadController::class, 'destroy'])->name('images.destroy');
    Route::delete('rankings/upload/{image}', [ImageUploadController::class, 'destroy'])->name('rankings.upload.destroy');

    Route::post('image-upload', [ImageUploadController::class, 'upload'])->name('stores.upload'); // Geral
    Route::delete('image-upload/{image}', [ImageUploadController::class, 'destroy'])->name('stores.upload.destroy'); // Geral
});
