@extends('layouts.app')
@section('title')
    Lojas
@endsection
@push('css')
    <link rel="stylesheet" href="{{ URL::asset('build/css/extra-icons.css') }}">
@endpush
@section('content')

    <x-page-title title="Lojas" subtitle="Listagem de Lojas" />

    <div class="row g-4">
        @foreach($stores as $store)
            <div class="col-12 col-xl-4 mt-5">
                <div class="card mb-0">
                    <div class="card-body">
                        <div class="position-relative">
                            <div class="position-absolute top-100 start-50 translate-middle">
                                <img src="{{ $store->image_id ? asset('storage/'.$store->image->path) : 'https://placehold.co/110x110/png' }}" width="100" height="100"
                                    class="rounded-circle raised borda-dourada" alt="{{ $store->name }}">
                            </div>
                        </div>
                        <div class="text-center mt-5 pt-4">
                            <h5 class="mb-2">{{ $store->name }}</h5>
                            @if($store->telefone)
                                <p class="mb-0 flex-stores"><i class="material-icons-outlined">phone</i> {{ $store->telefone }}</p>
                            @endif
                        </div>
                        <div class="d-flex align-items-center justify-content-around mt-4 text-center">
                            <ul class="lista-loja">
                                @if($store->rua || $store->numero || $store->bairro || $store->cidade || $store->cep || $store->estado)
                                    <li class="flex-stores"><i class="lni lni-home"></i> {{ $store->rua }}, {{ $store->numero }}, {{ $store->bairro }}, {{ $store->cep }}, {{ $store->cidade }} - {{ $store->estado }}</li>
                                @endif
                                @if($store->email)
                                    <li class="flex-stores"><i class="lni lni-envelope"></i> {{ $store->email }}</li>
                                @endif
                            </ul>
                        </div>
                        <hr>
                        <div class="d-flex align-items-center justify-content-center gap-3">
                            @if($store->instagram)
                                <a href="https://instagram.com/{{ $store->instagram }}" target="_blank"
                                    class="wh-48 bg-linkedin text-white rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-instagram fs-5"></i>
                                </a>
                            @endif
                            @if($store->telefone)
                                <a href="https://wa.me/55{{ preg_replace('/[^0-9]/', '', $store->telefone) }}" target="_blank"
                                    class="wh-48 bg-whatsapp text-white rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-whatsapp fs-5"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div><!--end row-->

    <!-- Paginação -->
    <div class="mt-4">
        {{ $stores->links('pagination::bootstrap-4') }}
    </div>

@endsection
@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
