@extends('layouts.app')
@section('title')
    Pontos
@endsection
@section('content')
    <x-page-title title="Pontos" subtitle="Lista de Pontos" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <form method="GET" action="{{ route('admin.points.index') }}" class="d-flex align-items-end gap-2 flex-wrap">
            <div>
                <label for="architect_id" class="form-label">Arquiteto</label>
                <select name="architect_id" id="architect_id" class="form-select">
                    <option value="">Todos os Arquitetos</option>
                    @foreach($architects as $architect)
                        <option value="{{ $architect->id }}" {{ request('architect_id') == $architect->id ? 'selected' : '' }}>
                            {{ $architect->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="start_date" class="form-label">Data Inicial</label>
                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="form-control">
            </div>
            <div>
                <label for="end_date" class="form-label">Data Final</label>
                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="form-control">
            </div>
            <div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
        </form>
        <a href="{{ route('manager.points.create') }}" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Atribuir Pontos</a>
    </div>

    <!-- Filtros Ativos -->
    <div class="mb-4">
        @if(request('architect_id'))
            <span class="badge bg-info text-dark">
                Arquiteto: {{ $architects->find(request('architect_id'))->name }}
                <a href="{{ route('manager.points.index', array_merge(request()->except('architect_id'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
        @if(request('start_date'))
            <span class="badge bg-info text-dark">
                Data Inicial: {{ request('start_date') }}
                <a href="{{ route('manager.points.index', array_merge(request()->except('start_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
        @if(request('end_date'))
            <span class="badge bg-info text-dark">
                Data Final: {{ request('end_date') }}
                <a href="{{ route('admanagermin.points.index', array_merge(request()->except('end_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Arquiteto</th>
                                <th>Pontos</th>
                                <th>Valor da Venda</th>
                                <th>Nome do Cliente</th>
                                <th>Descrição</th>
                                <th>Data</th>
                                <th class="text-right">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($points as $point)
                                <tr>
                                    <td>{{ $point->architect->name }}</td>
                                    <td>{{ number_format($point->points, 0, ',', '.') }}</td>
                                    <td>{{ 'R$ ' . number_format($point->sale_value, 2, ',', '.') }}</td>
                                    <td>{{ $point->customer_name }}</td>
                                    <td>{{ $point->description }}</td>
                                    <td>{{ $point->created_at->format('d/m/Y') }}</td>
                                    <td class="text-right">
                                        <a href="{{ route('manager.points.edit', $point->id) }}" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="{{ route('manager.points.destroy', $point->id) }}">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $points->appends(request()->query())->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este ponto?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
