@extends('layouts.app')
@section('title')
    Editar Ponto
@endsection
@section('content')
    <x-page-title title="Pontos" subtitle="Editar Ponto" />

    <div class="card mt-4">
        <div class="card-body">
            <form action="{{ route('manager.points.update', $point->id) }}" method="POST" id="point-form">
                @csrf
                @method('PUT')
                <div class="mb-4">
                    <label for="architect_id" class="form-label">Arquiteto</label>
                    <select name="architect_id" id="architect_id" class="form-select" required>
                        @foreach($architects as $architect)
                            <option value="{{ $architect->id }}" {{ $point->architect_id == $architect->id ? 'selected' : '' }}>
                                {{ $architect->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="mb-4">
                    <label for="scoring_rule_id" class="form-label">Regra de Pontuação</label>
                    <select name="scoring_rule_id" id="scoring_rule_id" class="form-select" required>
                        @foreach($scoringRules as $rule)
                            <option value="{{ $rule->id }}" data-amount="{{ $rule->amount_spent_per_point }}"
                                {{ $point->scoring_rule_id == $rule->id ? 'selected' : '' }}>
                                {{ $rule->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="mb-4">
                    <label for="sale_value" class="form-label">Valor da Venda</label>
                    <div class="input-group">
                        <span class="input-group-text">R$</span>
                        <input type="text" name="sale_value" id="sale_value" value="{{ number_format($point->sale_value, 2, ',', '.') }}" class="form-control" required>
                    </div>
                </div>
                <div class="mb-4">
                    <label for="calculated_points" class="form-label">Pontos Calculados</label>
                    <input type="text" id="calculated_points" class="form-control" value="{{ $point->points }}" readonly>
                </div>
                <div class="mb-4">
                    <label for="customer_name" class="form-label">Nome do Cliente</label>
                    <input type="text" name="customer_name" id="customer_name" value="{{ $point->customer_name }}" class="form-control" required>
                </div>
                <div class="mb-4">
                    <label for="description" class="form-label">Descrição</label>
                    <textarea name="description" id="description" class="form-control" required>{{ $point->description }}</textarea>
                </div>
                <button type="submit" class="btn btn-primary">Atualizar Ponto</button>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const saleValueInput = document.getElementById('sale_value');
            const scoringRuleSelect = document.getElementById('scoring_rule_id');
            const calculatedPointsInput = document.getElementById('calculated_points');

            function calculatePoints() {
                const saleValue = parseFloat(saleValueInput.value.replace(/\./g, '').replace(',', '.'));
                const amountSpentPerPoint = parseFloat(scoringRuleSelect.options[scoringRuleSelect.selectedIndex].getAttribute('data-amount'));
                
                if (!isNaN(saleValue) && !isNaN(amountSpentPerPoint)) {
                    const points = Math.floor(saleValue / amountSpentPerPoint);
                    calculatedPointsInput.value = points;
                } else {
                    calculatedPointsInput.value = '';
                }
            }

            saleValueInput.addEventListener('input', function () {
                let value = saleValueInput.value.replace(/\D/g, '');
                value = (value / 100).toFixed(2) + '';
                value = value.replace(".", ",");
                value = value.replace(/(\d)(?=(\d{3})+\,)/g, "$1.");
                saleValueInput.value = value;
                calculatePoints();
            });

            scoringRuleSelect.addEventListener('change', calculatePoints);

            document.getElementById('point-form').addEventListener('submit', function (event) {
                const saleValue = saleValueInput.value.replace(/\./g, '').replace(',', '.');
                saleValueInput.value = saleValue;
            });
        });
    </script>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
