@extends('layouts.app')
@section('title')
    Dashboard
@endsection
@push('css')
    <link rel="stylesheet" href="{{ URL::asset('build/css/extra-icons.css') }}">
@endpush
@section('content')
    
    <x-page-title title="Dashboard" subtitle="Início" />

    <div class="row">
        <div class="col-xl-12 d-flex align-items-stretch">
            <div class="card w-100 overflow-hidden rounded-4">
                <div class="card-body position-relative p-4">
                    <div class="row">
                        <div class="col-12 col-sm-7">
                            <div class="d-flex align-items-center gap-3 mb-5">
                                <img src="build/images/avatar.jpg" class="rounded-circle p-1 borda-dourada" width="60" height="60" alt="user">
                                <div class="">
                                    <p class="mb-0 fw-semibold">Olá,</p>
                                    <h4 class="fw-semibold fs-4 mb-0">{{ Auth::user()->name }}!</h4>
                                    <p class="mb-0">{{ $storeName }}</p> <!-- Exibe o nome da loja -->
                                </div>
                            </div>
                            <div class="d-flex align-items-center gap-5 quebra-mobile">
                                <div class="">
                                    <h4 class="mb-1 fw-semibold d-flex align-content-center">
                                        R${{ number_format($totalSales, 2, ',', '.') }}<i class="ti ti-arrow-up-right fs-5 lh-base text-success"></i>
                                    </h4>
                                    <p class="mb-3">Total em Vendas no Mês</p>
                                </div>
                                <div class="vr"></div>
                                <div class="">
                                    <h4 class="mb-1 fw-semibold d-flex align-content-center">
                                        {{ $numberOfSales }}<i class="ti ti-arrow-up-right fs-5 lh-base text-success"></i>
                                    </h4>
                                    <p class="mb-3">Número de Vendas</p>
                                </div>
                                <div class="vr"></div>
                                <div class="">
                                    <h4 class="mb-1 fw-semibold d-flex align-content-center">
                                        {{ number_format($totalPointsDistributed, 0, ',', '.') }}<i class="ti ti-arrow-up-right fs-5 lh-base text-success"></i>
                                    </h4>
                                    <p class="mb-3">Total de Pontos Distribuídos no Mês</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-sm-5">
                            <div class="welcome-back-img pt-4">
                                <img src="{{ URL::asset('build/images/gallery/welcome-back-3.png') }}" height="180" alt="">
                            </div>
                        </div>
                    </div><!--end row-->
                    
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-xl-4">
            <div class="card w-100 rounded-4">
                <div class="card-header border-0 p-3 border-bottom">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="">
                            <h5 class="mb-0">Aniversáriantes do Mês</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="user-list p-3">
                        <div class="d-flex flex-column gap-3">
                            @if($birthdayArchitects->isEmpty())
                                <div class="text-center p-3">
                                    <h6 class="mb-0">Não há nenhum aniversariante neste mês</h6>
                                </div>
                            @else
                                @foreach($birthdayArchitects as $architect)
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-0">
                                                <a href="{{ route('admin.architects.show', $architect->id) }}">
                                                    {{ $architect->name }}
                                                </a>
                                            </h6>
                                            <p class="mb-0">{{ \Carbon\Carbon::parse($architect->birth_date)->format('d/m/Y') }}</p>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
                
                
                
                       
            </div>
        </div>
        <div class="col-12 col-xl-8">
            <div class="card w-100 rounded-4">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between mb-3">
                        <div class="">
                            <h5 class="mb-0">Histórico de Vendas</h5>
                        </div>
                    </div>
                    <div id="chart5"></div>
                    <div class="d-flex align-items-start justify-content-around border p-3 rounded-4 mt-3 gap-3">
                        <div class="d-flex text-center align-items-center gap-4">
                            <div class="">
                                <p class="mb-1 fs-6 fw-bold">Total do Mês</p>
                                <h3 class="mb-0">R${{ number_format($totalSalesThisMonth, 2, ',', '.') }}</h3>
                                <p class="mb-0"><span>{{ $numberOfSalesThisMonth }} Vendas</span></p>
                            </div>
                        </div>
                        <div class="vr"></div>
                        <div class="d-flex text-center align-items-center gap-4">
                            <div class="">
                                <p class="mb-1 fs-6 fw-bold">Total do Ano</p>
                                <h3 class="mb-0">R${{ number_format($totalSalesThisYear, 2, ',', '.') }}</h3>
                                <p class="mb-0"><span>{{ $numberOfSalesThisYear }} Vendas</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->
    <div class="row row-cols-1 row-cols-xl-3 mt-4">
        @foreach($activeRankings as $ranking)
            <div class="col">
                <div class="card">
                    <div class="card-img-container rounded">
                        <img src="{{ $ranking->image ? asset('storage/'.$ranking->image->path) : 'https://placehold.co/400x300/png' }}" class="card-img" alt="Imagem do Ranking">
                    </div>
                    <div class="card-body p-4">
                        <h4 class="">{{ $ranking->name }}</h4>
                        <h6><i class="lni lni-calendar"></i> {{ $ranking->start_date->format('d/m/Y') }} á {{ $ranking->end_date->format('d/m/Y') }}</h6>
                        {!! $ranking->description !!}
    
                        <hr class="my-12"/>
    
                        <div class="my-4 text-center">
                            <a href="{{ route('manager.rankings.show', $ranking->id) }}" class="btn btn-grd-primary border-0 btn-md px-5">Ver Ranking Completo</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div><!--end row-->
    
    
@endsection
@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/apexchart/apexcharts.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/peity/jquery.peity.min.js') }}"></script>
    <script>
        $(".data-attributes span").peity("donut")
    </script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
    <script>
    $(function () {
        "use strict";
    
        var options = {
            series: [{
                name: "Valor em vendas",
                data: @json($salesByMonth)
            },
            {
                name: "Número de Vendas",
                data: @json($salesCountByMonth)
            }],
            chart: {
                foreColor: "#9ba7b2",
                height: 235,
                type: 'bar',
                toolbar: {
                    show: !1,
                },
                sparkline: {
                    enabled: !1
                },
                zoom: {
                    enabled: false
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                width: 4,
                curve: 'smooth',
                colors: ['transparent']
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shade: 'dark',
                    gradientToColors: ['#ffd200', '#00c6fb'],
                    shadeIntensity: 1,
                    type: 'vertical',
                    stops: [0, 100, 100, 100]
                },
            },
            colors: ['#ff6a00', "#005bea"],
            plotOptions: {
                bar: {
                    horizontal: false,
                    borderRadius: 4,
                    columnWidth: '55%',
                }
            },
            grid: {
                show: false,
                borderColor: 'rgba(0, 0, 0, 0.15)',
                strokeDashArray: 4,
            },
            tooltip: {
                theme: "dark",
                fixed: {
                    enabled: !0
                },
                x: {
                    show: !0
                },
                y: {
                    title: {
                        formatter: function () {
                            return ""
                        }
                    }
                },
                marker: {
                    show: !1
                }
            },
            xaxis: {
                categories: @json($months),
            }
        };

        var chart = new ApexCharts(document.querySelector("#chart5"), options);
        chart.render();
    });    
    </script>

    <script>
        new PerfectScrollbar(".user-list")
    </script>
@endpush
