@extends('layouts.app')

@section('title', $ranking->name)
@push('css')
    <link rel="stylesheet" href="{{ URL::asset('build/css/extra-icons.css') }}">
@endpush

@section('content')
    <div class="container">
        <!-- Seção comum para ambos os tipos de ranking -->
        <div class="card mb-4">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <img src="{{ $ranking->image ? asset('storage/'.$ranking->image->path) : asset('images/default-image.jpg') }}" class="img-fluid rounded" alt="{{ $ranking->name }}">
                </div>
                <div class="col-md-6">
                    <h1>{{ $ranking->name }}</h1>
                    <p><i class="lni lni-calendar"></i> {{ $ranking->start_date->format('d/m/Y') }} á {{ $ranking->end_date->format('d/m/Y') }}</p>
                    {!! $ranking->description !!}
                    <p>Status: {{ $ranking->is_active ? 'Ativo' : 'Inativo' }}</p>
                    <p>Criado por: {{ $admin ? $admin->name : 'Admin não encontrado' }}</p>
                    @if($ranking->type === 'position')
                        <p>Sua posição nesse ranking: #{{ $userPosition ?? 'N/A' }}</p>
                    @elseif($ranking->type === 'goal')
                        <p>Você tem <b>{{ number_format($userPoints, 0, ',', '.') }}</b> pontos neste ranking</p>
                    @endif
                </div>
            </div>
        </div>
        
        @if($ranking->type === 'goal')
            <!-- Layout para o tipo por meta -->
            <div class="row">
                @foreach($ranking->rewards as $reward)
                    <div class="col-md-4 mb-4">
                        <div class="card">
                            <img src="{{ asset('storage/'.$reward->image->path) }}" class="card-img-top" alt="{{ $reward->name }}">
                            <div class="card-body">
                                <h5 class="card-title">{{ $reward->name }}</h5>
                                <p class="card-text">Pontos Necessários: {{ $reward->points_required }}</p>
                                @if(in_array($reward, $qualifiedRewards))
                                    <p class="text-success">Você atingiu os pontos necessários!</p>
                                @else
                                    <p class="text-danger">Você ainda não atingiu os pontos necessários.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @elseif($ranking->type === 'position')
            <!-- Layout para o tipo por posição -->
            <div class="row">
                <div class="col-md-12">
                    <h2>Prêmios</h2>
                    <div class="row">
                        @php $qualified = false; @endphp
                        @foreach($ranking->rewards as $reward)
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="row g-0 align-items-center">
                                        <div class="col-md-4">
                                            <img src="{{ asset('storage/'.$reward->image->path) }}" class="img-fluid rounded-start" alt="{{ $reward->name }}">
                                        </div>
                                        <div class="col-md-8">
                                            <div class="card-body">
                                                <h5 class="card-title">{{ $reward->name }}</h5>
                                                <p class="card-text">Posição Necessária: {{ $reward->position_required }}</p>
                                                @if($userPosition <= $reward->position_required && !$qualified)
                                                    <h6>Você está se qualificando para este prêmio!</h6>
                                                    @php $qualified = true; @endphp
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    
                </div>
            </div>
        @endif
    </div>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
