@extends('layouts.app')
@section('title')
    Rankings
@endsection
@push('css')
    <link rel="stylesheet" href="{{ URL::asset('build/css/extra-icons.css') }}">
@endpush
@section('content')
    
    <x-page-title title="Meus Rankings" subtitle="Rankings" />

    <div class="row row-cols-1 row-cols-xl-2 mt-4">
        @foreach($activeRankings as $ranking)
            <div class="col">
                <div class="card">
                    <div class="card-img-container rounded">
                        <img src="{{ $ranking->image ? asset('storage/'.$ranking->image->path) : 'https://placehold.co/400x300/png' }}" class="card-img" alt="Imagem do Ranking">
                    </div>
                    <div class="card-body p-4">
                        <h4 class="">{{ $ranking->name }}</h4>
                        <h6><i class="lni lni-calendar"></i> {{ $ranking->start_date->format('d/m/Y') }} á {{ $ranking->end_date->format('d/m/Y') }}</h6>
                        {!! $ranking->description !!}
    
                        <hr class="my-12"/>
    
                        <div class="my-4 text-center">
                            <a href="{{ route('architect.rankings.show', $ranking->id) }}" class="btn btn-grd-primary border-0 btn-md px-5">Ver Ranking Completo</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div><!--end row-->
@endsection
@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/apexchart/apexcharts.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/peity/jquery.peity.min.js') }}"></script>
    <script>
        $(".data-attributes span").peity("donut")
    </script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
    <script src="{{ URL::asset('build/js/dashboard2.js') }}"></script>
    <script>
        new PerfectScrollbar(".user-list")
    </script>
@endpush
