@extends('layouts.app')
@section('title')
    Pontos
@endsection
@section('content')
    <x-page-title title="Meus Pontos" subtitle="Lista de Pontos" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4 mb-4">
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-success text-success bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">{{ $pointsThisMonth }}</h4>
                            <p class="mb-0">Pontos Ganhos No Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-danger text-danger bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">{{ $pointsThisYear }}</h4>
                            <p class="mb-0">Pontos Ganhos No Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-info text-info bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ {{ number_format($salesThisMonth, 2, ',', '.') }}</h4>
                            <p class="mb-0">Valor em Vendas no Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-orange-light text-orange bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ {{ number_format($salesThisYear, 2, ',', '.') }}</h4>
                            <p class="mb-0">Valor em Vendas no Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->

    <!-- Formulário de Filtros -->
<form method="GET" action="{{ route('architect.points.index') }}" class="d-flex align-items-end gap-2 flex-wrap">
    <div>
        <label for="start_date" class="form-label">Data Inicial</label>
        <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="form-control">
    </div>
    <div>
        <label for="end_date" class="form-label">Data Final</label>
        <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="form-control">
    </div>
    <div>
        <label for="store_id" class="form-label">Loja</label>
        <select name="store_id" id="store_id" class="form-select">
            <option value="">Todas as Lojas</option>
            @foreach($stores as $store)
                <option value="{{ $store->id }}" {{ request('store_id') == $store->id ? 'selected' : '' }}>{{ $store->name }}</option>
            @endforeach
        </select>
    </div>
    <div>
        <button type="submit" class="btn btn-primary">Filtrar</button>
    </div>
</form>

<!-- Filtros Ativos -->
<div class="mb-4">
    @if(request('start_date'))
        <span class="badge bg-info text-dark">
            Data Inicial: {{ request('start_date') }}
            <a href="{{ route('architect.points.index', array_merge(request()->except('start_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
        </span>
    @endif
    @if(request('end_date'))
        <span class="badge bg-info text-dark">
            Data Final: {{ request('end_date') }}
            <a href="{{ route('architect.points.index', array_merge(request()->except('end_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
        </span>
    @endif
    @if(request('store_id'))
        <span class="badge bg-info text-dark">
            Loja: {{ $stores->find(request('store_id'))->name }}
            <a href="{{ route('architect.points.index', array_merge(request()->except('store_id'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
        </span>
    @endif
</div>

<!-- Tabela de Pontos -->
<div class="card mt-4">
    <div class="card-body">
        <div class="customer-table">
            <div class="table-responsive white-space-nowrap">
                <table class="table mb-0 table-dark table-striped align-middle">
                    <thead>
                        <tr>
                            <th>Pontos</th>
                            <th>Valor da Venda</th>
                            <th>Nome do Cliente</th>
                            <th>Loja</th>
                            <th>Descrição</th>
                            <th>Data</th>
                            <th>Vendedor</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($points as $point)
                            <tr>
                                <td>{{ number_format($point->points, 0, ',', '.') }}</td>
                                <td>{{ 'R$ ' . number_format($point->sale_value, 2, ',', '.') }}</td>
                                <td>{{ $point->customer_name }}</td>
                                <td>{{ $point->store->name ?? 'Loja não encontrada' }}</td>
                                <td>{{ $point->description }}</td>
                                <td>{{ $point->created_at->format('d/m/Y - H:i:s') }}</td>
                                <td>{{ $point->admin->name }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="rodape-tabela">
                        <tr>
                            <th>Total: {{ number_format($totalPoints, 0, ',', '.') }}</th>
                            <th>Total: {{ 'R$ ' . number_format($totalSales, 2, ',', '.') }}</th>
                            <th colspan="5"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <div class="mt-4">
                {{ $points->appends(request()->query())->links('pagination::bootstrap-4') }}
            </div>
        </div>
    </div>
</div>


    


@endsection
