@extends('layouts.app')
@section('title')
    Dashboard
@endsection
@push('css')
    <link rel="stylesheet" href="{{ URL::asset('build/css/extra-icons.css') }}">
@endpush
@section('content')
    
    <x-page-title title="Dashboard" subtitle="Início" />

    <div class="row">
        <div class="col-xl-12 d-flex align-items-stretch">
            <div class="card w-100 overflow-hidden rounded-4">
                <div class="card-body position-relative p-4">
                    <div class="row">
                        <div class="col-12 col-sm-7">
                            <div class="d-flex align-items-center gap-3 mb-5">
                                <img src="build/images/avatar.jpg" class="rounded-circle borda-dourada p-1"
                                    width="60" height="60" alt="user">
                                <div class="">
                                    <p class="mb-0 fw-semibold">Olá,</p>
                                    <h4 class="fw-semibold fs-4 mb-0">{{ Auth::user()->name }}!</h4>
                                </div>
                            </div>
                            <div class="d-flex align-items-center gap-5 quebra-mobile">
                                
                                <div class="">
                                    <h4 class="mb-1 fw-semibold d-flex align-content-center">
                                        {{ number_format($totalPointsThisMonth, 0, ',', '.') }}<i class="ti ti-arrow-up-right fs-5 lh-base text-success"></i>
                                    </h4>
                                    <p class="mb-3">Total de Pontos no Mês</p>
                                </div>
                                <div class="vr"></div>
                                <div class="">
                                    <h4 class="mb-1 fw-semibold d-flex align-content-center">
                                        R${{ number_format($totalSalesThisMonth, 2, ',', '.') }}<i class="ti ti-arrow-up-right fs-5 lh-base text-success"></i>
                                    </h4>
                                    <p class="mb-3">Total em Vendas no Mês</p>
                                </div>
                                <div class="vr"></div>
                                <div class="">
                                    <h4 class="mb-1 fw-semibold d-flex align-content-center">
                                        {{ $numberOfSalesThisMonth }}<i class="ti ti-arrow-up-right fs-5 lh-base text-success"></i>
                                    </h4>
                                    <p class="mb-3">Número de Vendas</p>
                                </div>
                                
                            </div>
                        </div>
                        <div class="col-12 col-sm-5">
                            <div class="welcome-back-img pt-4">
                                <img src="{{ URL::asset('build/images/gallery/welcome-back-3.png') }}" height="180" alt="">
                            </div>
                        </div>
                    </div><!--end row-->
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card w-100 rounded-4">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between mb-3">
                        <div class="">
                            <h5 class="mb-0">Pontos & Vendas</h5>
                        </div>
                    </div>
                    <div class="d-flex align-items-start justify-content-around border p-3 rounded-4 mt-3 gap-3">
                        <div class="d-flex text-center align-items-center gap-4">
                            <div class="">
                                <p class="mb-1 fs-6 fw-bold">Total do Mês</p>
                                <h3 class="mb-0">R${{ number_format($totalSalesThisMonth, 2, ',', '.') }}</h3>
                                <p class="mb-0"><span>{{ number_format($totalPointsThisMonth, 0, ',', '.') }} Pontos</span></p>
                            </div>
                        </div>
                        <div class="vr"></div>
                        <div class="d-flex text-center align-items-center gap-4">
                            <div class="">
                                <p class="mb-1 fs-6 fw-bold">Total do Ano</p>
                                <h3 class="mb-0">R${{ number_format($totalSalesThisYear, 2, ',', '.') }}</h3>
                                <p class="mb-0"><span>{{ number_format($totalPointsThisYear, 0, ',', '.') }} Pontos</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->

    <div class="row row-cols-1 row-cols-xl-2 mt-4">
        @foreach($activeRankings as $ranking)
            <div class="col">
                <div class="card">
                    <div class="card-img-container rounded">
                        <img src="{{ $ranking->image ? asset('storage/'.$ranking->image->path) : 'https://placehold.co/400x300/png' }}" class="card-img" alt="Imagem do Ranking">
                    </div>
                    <div class="card-body p-4">
                        <h4 class="">{{ $ranking->name }}</h4>
                        <h6><i class="lni lni-calendar"></i> {{ $ranking->start_date->format('d/m/Y') }} á {{ $ranking->end_date->format('d/m/Y') }}</h6>
                        {!! $ranking->description !!}
    
                        <hr class="my-12"/>
    
                        <div class="my-4 text-center">
                            <a href="{{ route('architect.rankings.show', $ranking->id) }}" class="btn btn-grd-primary border-0 btn-md px-5">Ver Ranking Completo</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div><!--end row-->
    
@endsection
@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
