@extends('layouts.app')
@section('title')
    Usuários
@endsection
@section('content')
    <x-page-title title="Usuários" subtitle="Lista de Usuários" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex align-items-center gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <a href="{{ route('admin.users.index') }}">
            <span class="me-1">Todos</span>
            <span class="text-secondary">({{ $totalUsers }})</span>
        </a>
        <a href="{{ route('admin.users.index', ['role' => 'admin']) }}">
            <span class="me-1">Admins</span>
            <span class="text-secondary">({{ $totalAdmins }})</span>
        </a>
        <a href="{{ route('admin.users.index', ['role' => 'store_manager']) }}">
            <span class="me-1">Gerentes de Loja</span>
            <span class="text-secondary">({{ $totalStoreManagers }})</span>
        </a>
    </div>

    <div class="row g-3">
        <div class="col-auto">
            <div class="position-relative">
                <form method="GET" action="{{ route('admin.users.index') }}" class="d-flex align-items-center">
                    <input class="form-control px-5" type="search" name="search" placeholder="Buscar Usuários" value="{{ request('search') }}">
                    <span class="material-icons-outlined position-absolute ms-3 translate-middle-y start-0 top-50 fs-5">search</span>
                </form>
            </div>
        </div>
        <div class="col-auto flex-grow-1 overflow-auto">
            <div class="btn-group position-static">
                <button type="button" class="btn btn-filter dropdown-toggle px-4" data-bs-toggle="dropdown" aria-expanded="false">
                    {{ request('role') == 'store_manager' ? 'Gerente de Loja' : 'Admin' }}
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="{{ route('admin.users.index') }}">Todos</a></li>
                    <li><a class="dropdown-item" href="{{ route('admin.users.index', ['role' => 'admin']) }}">Admin</a></li>
                    <li><a class="dropdown-item" href="{{ route('admin.users.index', ['role' => 'store_manager']) }}">Gerente de Loja</a></li>
                </ul>
            </div>
        </div>
        <div class="col-auto">
            <div class="d-flex align-items-center gap-2 justify-content-lg-end">
                <a href="{{ route('admin.users.create') }}" class="btn btn-primary px-4"><i class="bi bi-plus-lg me-2"></i>Criar Novo Usuário</a>
            </div>
        </div>
    </div><!--end row-->

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Tipo</th>
                                <th class="text-end">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $user)
                                <tr>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->role == 'admin' ? 'Admin' : 'Gerente de Loja' }}</td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="{{ route('admin.users.destroy', $user->id) }}">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $users->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este usuário?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
@endsection

@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
