@extends('layouts.app')
@section('title')
    Lojas
@endsection
@section('content')
    <x-page-title title="Lojas" subtitle="Lista de Lojas" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <form method="GET" action="{{ route('admin.stores.index') }}" class="d-flex align-items-end gap-2 flex-wrap">
            <!-- Aqui você pode adicionar filtros para a listagem de lojas futuramente -->
        </form>
        <a href="{{ route('admin.stores.create') }}" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Adicionar Nova Loja</a>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Imagem</th>
                                <th>Título</th>
                                <th>Telefone</th>
                                <th class="text-right">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($stores as $store)
                                <tr>
                                    <td>
                                        @if($store->image)
                                            <img src="{{ asset('storage/' . $store->image->path) }}" alt="{{ $store->name }}" width="50" class="img-thumbnail">
                                        @else
                                            <img src="{{ asset('images/default-store.png') }}" alt="Sem imagem" width="50" class="img-thumbnail">
                                        @endif
                                    </td>
                                    <td>{{ $store->name }}</td>
                                    <td>{{ $store->telefone }}</td>
                                    <td class="text-right">
                                        <a href="{{ route('admin.stores.edit', $store->id) }}" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="{{ route('admin.stores.destroy', $store->id) }}">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $stores->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir esta loja?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
