@extends('layouts.app')
@section('title')
    Criar Loja
@endsection
@section('content')
    <x-page-title title="Lojas" subtitle="Criar Loja" />

    <div class="card mt-4">
        <div class="card-body">
            <form id="store-form" action="{{ route('admin.stores.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-4">
                    <label for="name" class="form-label">Nome da Loja</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}" required>
                </div>
                <div class="mb-4">
                    <label for="telefone" class="form-label">Telefone</label>
                    <input type="text" name="telefone" id="telefone" class="form-control" value="{{ old('telefone') }}">
                </div>
                <div class="mb-4">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}">
                </div>
                <div class="mb-4">
                    <label for="cep" class="form-label">CEP</label>
                    <input type="text" name="cep" id="cep" class="form-control" value="{{ old('cep') }}">
                </div>
                <div class="mb-4">
                    <label for="rua" class="form-label">Rua</label>
                    <input type="text" name="rua" id="rua" class="form-control" value="{{ old('rua') }}">
                </div>
                <div class="mb-4">
                    <label for="numero" class="form-label">Número</label>
                    <input type="text" name="numero" id="numero" class="form-control" value="{{ old('numero') }}">
                </div>
                <div class="mb-4">
                    <label for="bairro" class="form-label">Bairro</label>
                    <input type="text" name="bairro" id="bairro" class="form-control" value="{{ old('bairro') }}">
                </div>
                <div class="mb-4">
                    <label for="cidade" class="form-label">Cidade</label>
                    <input type="text" name="cidade" id="cidade" class="form-control" value="{{ old('cidade') }}">
                </div>
                <div class="mb-4">
                    <label for="estado" class="form-label">Estado</label>
                    <input type="text" name="estado" id="estado" class="form-control" value="{{ old('estado') }}">
                </div>
                <div class="mb-4">
                    <label for="instagram" class="form-label">Instagram</label>
                    <input type="text" name="instagram" id="instagram" class="form-control" value="{{ old('instagram') }}">
                </div>
                <div class="mb-4" id="image-upload-container">
                    <label for="logo" class="form-label">Logo da Loja</label>
                    <input id="fancy-file-upload" type="file" name="files[]" accept="image/*">
                    <input type="hidden" name="image_id" id="image_id">
                </div>
                <div id="image-preview-container" class="mb-4" style="display:none;">
                    <label class="form-label">Logo da Loja</label>
                    <div id="image-preview"></div>
                    <button type="button" id="remove-image" class="btn btn-danger mt-2">Remover Imagem</button>
                </div>
                
                <button type="submit" class="btn btn-primary">Salvar</button>
            </form>
        </div>
    </div>

@endsection

@push('css')
    <link href="{{ URL::asset('build/plugins/fancy-file-uploader/fancy_fileupload.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script src="{{ URL::asset('build/plugins/fancy-file-uploader/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/fancy-file-uploader/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/fancy-file-uploader/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/fancy-file-uploader/jquery.fancy-fileupload.js') }}"></script>
    <script>
        $(document).ready(function() {
            var formChanged = false;

            // Monitorar mudanças no formulário
            $('#store-form').on('change input', function() {
                formChanged = true;
            });

            // Configuração do Fancy File Upload
            $('#fancy-file-upload').FancyFileUpload({
                url: '{{ route("admin.stores.upload") }}',
                params: {
                    _token: '{{ csrf_token() }}'
                },
                maxfilesize: 1000000, // Limite de tamanho de 1MB
                accept: ['jpg', 'jpeg', 'png', 'gif'],
                added: function (e, data) {
                    formChanged = true; // Marcar como modificado quando um arquivo é adicionado
                    if (data.ff_info.errors.length == 0) {
                        data.submit().done(function (response) {
                            if (response.success) {
                                $('#image_id').val(response.image_id);
                                $('#image-upload-container').hide();
                                $('#image-preview-container').show();
                                $('#image-preview').html('<img src="'+response.location+'" class="img-fluid" alt="Logo da Loja">');
                            } else {
                                console.error('Erro ao processar a resposta: ', response);
                            }
                        }).fail(function (jqXHR, textStatus, errorThrown) {
                            console.error('Erro ao enviar o arquivo: ', textStatus, errorThrown);
                        });
                    } else {
                        console.error('Erro ao adicionar o arquivo: ', data.ff_info.errors);
                    }
                },
                render: function() {
                    $(this).find('.ff_fileupload_upload').remove();
                },
                fail: function (e, data) {
                    console.error('Erro geral: ', data.ff_info.errors);
                }
            });

            $('#remove-image').on('click', function() {
                var imageId = $('#image_id').val();
                formChanged = true; // Marcar como modificado quando a imagem é removida
                $.ajax({
                    url: '{{ route("admin.stores.upload.destroy", '') }}/' + imageId,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#image_id').val('');
                            $('#image-upload-container').show();
                            $('#image-preview-container').hide();
                            $('#image-preview').html('');
                            $('#fancy-file-upload').next('.ff_fileupload_wrap').remove();
                            $('#fancy-file-upload').FancyFileUpload({
                                url: '{{ route("admin.stores.upload") }}',
                                params: {
                                    _token: '{{ csrf_token() }}'
                                },
                                maxfilesize: 1000000,
                                accept: ['jpg', 'jpeg', 'png', 'gif'],
                                added: function (e, data) {
                                    if (data.ff_info.errors.length == 0) {
                                        data.submit().done(function (response) {
                                            if (response.success) {
                                                $('#image_id').val(response.image_id);
                                                $('#image-upload-container').hide();
                                                $('#image-preview-container').show();
                                                $('#image-preview').html('<img src="'+response.location+'" class="img-fluid" alt="Logo da Loja">');
                                            } else {
                                                console.error('Erro ao processar a resposta: ', response);
                                            }
                                        }).fail(function (jqXHR, textStatus, errorThrown) {
                                            console.error('Erro ao enviar o arquivo: ', textStatus, errorThrown);
                                        });
                                    } else {
                                        console.error('Erro ao adicionar o arquivo: ', data.ff_info.errors);
                                    }
                                },
                                render: function() {
                                    $(this).find('.ff_fileupload_upload').remove();
                                },
                                fail: function (e, data) {
                                    console.error('Erro geral: ', data.ff_info.errors);
                                }
                            });
                        } else {
                            console.error('Erro ao excluir a imagem: ', response);
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.error('Erro ao excluir a imagem: ', textStatus, errorThrown);
                    }
                });
            });

            // Remover alerta de mudanças não salvas ao submeter o formulário
            $('#store-form').on('submit', function() {
                formChanged = false;
                $(window).off('beforeunload');
            });

            // Exibir alerta se o usuário tentar sair da página sem salvar
            $(window).on('beforeunload', function() {
                if (formChanged) {
                    return 'É possível que as alterações feitas não sejam salvas.';
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            const cepInput = document.getElementById('cep');
            const phoneInput = document.getElementById('telefone'); // Adaptado para o campo de telefone do formulário de loja

            // Máscara para o campo de telefone
            phoneInput.addEventListener('input', function () {
                phoneInput.value = phoneInput.value.replace(/\D/g, '')
                    .replace(/(\d{2})(\d)/, '($1) $2')
                    .replace(/(\d{5})(\d{1,4})$/, '$1-$2');
            });

            // Máscara para o campo de CEP
            cepInput.addEventListener('input', function () {
                cepInput.value = cepInput.value.replace(/\D/g, '').replace(/(\d{5})(\d)/, '$1-$2');
            });

            // Autocompletar endereço com base no CEP
            cepInput.addEventListener('blur', function () {
                const cep = cepInput.value.replace(/\D/g, '');
                if (cep !== '') {
                    const validacep = /^[0-9]{8}$/;
                    if (validacep.test(cep)) {
                        fetch(`https://viacep.com.br/ws/${cep}/json/`)
                            .then(response => response.json())
                            .then(data => {
                                if (!data.erro) {
                                    document.getElementById('rua').value = data.logradouro;
                                    document.getElementById('bairro').value = data.bairro;
                                    document.getElementById('cidade').value = data.localidade;
                                    document.getElementById('estado').value = data.uf;
                                } else {
                                    alert("CEP não encontrado.");
                                }
                            })
                            .catch(error => console.error('Erro ao buscar CEP:', error));
                    } else {
                        alert("Formato de CEP inválido.");
                    }
                }
            });
        });


    </script>
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
