@extends('layouts.app')
@section('title')
    Regras de Pontuação
@endsection
@section('content')
    <x-page-title title="Regras de Pontuação" subtitle="Lista de Regras" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <a href="{{ route('admin.scoring-rules.create') }}" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Criar Nova Regra</a>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <div class="table-responsive white-space-nowrap">
                <table class="table mb-0 table-dark table-striped align-middle">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Reais Gastos por Ponto</th>
                            <th>Status</th>
                            <th>Destaque</th>
                            <th>Criado por</th>
                            <th class="text-end">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($scoringRules as $rule)
                            <tr>
                                <td>{{ $rule->name }}</td>
                                <td>{{ 'R$ ' . number_format($rule->amount_spent_per_point, 2, ',', '.') }}</td>
                                <td>{{ $rule->is_active ? 'Ativo' : 'Desativado' }}</td>
                                <td>{{ $rule->is_featured ? 'Sim' : 'Não' }}</td>
                                <td>{{ $rule->admin->name }}</td>
                                <td class="text-end">
                                    <a href="{{ route('admin.scoring-rules.edit', $rule->id) }}" class="btn btn-warning btn-sm">Editar</a>
                                    <form action="{{ route('admin.scoring-rules.destroy', $rule->id) }}" method="POST" class="d-inline-block">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm">Excluir</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $scoringRules->links('pagination::bootstrap-4') }}
            </div>
        </div>
    </div>
@endsection

@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
