@extends('layouts.app')
@section('title')
    Criar Regra de Pontuação
@endsection
@section('content')
    <x-page-title title="Regras de Pontuação" subtitle="Criar Regra de Pontuação" />

    <div class="card mt-4">
        <div class="card-body">
            <form action="{{ route('admin.scoring-rules.store') }}" method="POST">
                @csrf
                <div class="mb-4">
                    <label for="name" class="form-label">Nome da Regra</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="amount_spent_per_point" class="form-label">Reais Gastos por Ponto</label>
                    <input type="number" step="0.01" name="amount_spent_per_point" id="amount_spent_per_point" class="form-control" value="{{ old('amount_spent_per_point') }}" required>
                    @error('amount_spent_per_point')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="is_active" class="form-label">Ativo</label>
                    <select name="is_active" id="is_active" class="form-select" required>
                        <option value="1" {{ old('is_active') == 1 ? 'selected' : '' }}>Sim</option>
                        <option value="0" {{ old('is_active') == 0 ? 'selected' : '' }}>Não</option>
                    @error('is_active')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                    </select>
                </div>
                <div class="mb-4">
                    <label for="is_featured" class="form-label">Destaque</label>
                    <select name="is_featured" id="is_featured" class="form-select" required>
                        <option value="1" {{ old('is_featured') == 1 ? 'selected' : '' }}>Sim</option>
                        <option value="0" {{ old('is_featured') == 0 ? 'selected' : '' }}>Não</option>
                    @error('is_featured')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Salvar</button>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
