@extends('layouts.app')

@section('title', $ranking->name)
@push('css')
    <link rel="stylesheet" href="{{ URL::asset('build/css/extra-icons.css') }}">
@endpush

@section('content')
    <div class="container">
        <!-- Seção comum para ambos os tipos de ranking -->
        <div class="card mb-4">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <img src="{{ $ranking->image ? asset('storage/'.$ranking->image->path) : asset('images/default-image.jpg') }}" class="img-fluid rounded" alt="{{ $ranking->name }}">
                </div>
                <div class="col-md-6">
                    <h1>{{ $ranking->name }}</h1>
                    <p><i class="lni lni-calendar"></i> {{ $ranking->start_date->format('d/m/Y') }} á {{ $ranking->end_date->format('d/m/Y') }}</p>
                    {!! $ranking->description !!}
                    <p>Status: {{ $ranking->is_active ? 'Ativo' : 'Inativo' }}</p>
                    <p>Criado por: {{ $admin ? $admin->name : 'Admin não encontrado' }}</p>
                </div>
            </div>
        </div>
        
        @if($ranking->type === 'goal')
            <!-- Layout para o tipo por meta -->
            <div class="row">
                @foreach($ranking->rewards as $reward)
                    <div class="col-md-4 mb-4">
                        <div class="card">
                            <img src="{{ asset('storage/'.$reward->image->path) }}" class="card-img-top" alt="{{ $reward->name }}">
                            <div class="card-body ">
                                <h5 class="card-title">{{ $reward->name }}</h5>
                                <p class="card-text">Pontos Necessários: {{ $reward->points_required }}</p>
                                <h6>Arquitetos Qualificados:</h6>
                                <ul>
                                    @if(isset($qualifiedArchitects[$reward->id]))
                                        @foreach($qualifiedArchitects[$reward->id] as $architect)
                                            <li>{{ $architect->name }} ({{ $architect->points_sum_points ?? 0 }} pontos)</li>
                                        @endforeach
                                    @else
                                        <li>Nenhum arquiteto qualificado.</li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @elseif($ranking->type === 'position')
            <!-- Layout para o tipo por posição -->
            <div class="row">
                <div class="col-md-6">
                    <h2>Prêmios</h2>
                    @foreach($ranking->rewards as $reward)
                        <div class="card mb-3">
                            <div class="row g-0 align-items-center">
                                <div class="col-md-4">
                                    <img src="{{ asset('storage/'.$reward->image->path) }}" class="img-fluid rounded-start" alt="{{ $reward->name }}">
                                </div>
                                <div class="col-md-8">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ $reward->name }}</h5>
                                        <p class="card-text">Posição Necessária: {{ $reward->position_required }}</p>
                                        @if($reward->architect)
                                            <p class="card-text">Ganhador Atual: {{ $reward->architect->name }} ({{ $reward->architect->points_sum_points ?? 0 }} pontos)</p>
                                        @else
                                            <p class="card-text">Ainda não há ganhador para esta posição.</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="col-md-6">
                    <h2>Ranking de Arquitetos</h2>
                    <ul class="list-group">
                        @foreach($architectRanking as $architect)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ $architect->name }}
                                <span class="badge bg-primary rounded-pill">
                                    {{ $architect->points_sum_points ?? 0 }} pontos
                                </span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif
    </div>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
