@extends('layouts.app')
@section('title')
    Rankings
@endsection
@section('content')
    <x-page-title title="Rankings" subtitle="Lista de Rankings" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <form method="GET" action="{{ route('admin.rankings.index') }}" class="d-flex align-items-end gap-2 flex-wrap">
            <div>
                <label for="start_date" class="form-label">Data Inicial</label>
                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="form-control">
            </div>
            <div>
                <label for="end_date" class="form-label">Data Final</label>
                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="form-control">
            </div>
            <div>
                <label for="is_active" class="form-label">Ativo</label>
                <select name="is_active" id="is_active" class="form-select">
                    <option value="">Todos</option>
                    <option value="1" {{ request('is_active') == 1 ? 'selected' : '' }}>Sim</option>
                    <option value="0" {{ request('is_active') == 0 ? 'selected' : '' }}>Não</option>
                </select>
            </div>
            <div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
        </form>
        <a href="{{ route('admin.rankings.create') }}" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Criar Ranking</a>
    </div>

    <!-- Filtros Ativos -->
    <div class="mb-4">
        @if(request('start_date'))
            <span class="badge bg-info text-dark">
                Data Inicial: {{ request('start_date') }}
                <a href="{{ route('admin.rankings.index', array_merge(request()->except('start_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
        @if(request('end_date'))
            <span class="badge bg-info text-dark">
                Data Final: {{ request('end_date') }}
                <a href="{{ route('admin.rankings.index', array_merge(request()->except('end_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
        @if(request('is_active') !== null && request('is_active') !== '')
            <span class="badge bg-info text-dark">
                Ativo: {{ request('is_active') == 1 ? 'Sim' : 'Não' }}
                <a href="{{ route('admin.rankings.index', array_merge(request()->except('is_active'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Data de Início</th>
                                <th>Data de Fim</th>
                                <th>Tipo</th> <!-- Nova coluna de tipo -->
                                <th>Ativo</th>
                                <th class="text-end">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rankings as $ranking)
                                <tr>
                                    <td>{{ $ranking->name }}</td>
                                    <td>{{ $ranking->start_date->format('d/m/Y') }}</td>
                                    <td>{{ $ranking->end_date->format('d/m/Y') }}</td>
                                    <td>{{ $ranking->type === 'goal' ? 'Por Meta' : 'Por Posição' }}</td> <!-- Exibe o tipo de ranking -->
                                    <td>{{ $ranking->is_active ? 'Sim' : 'Não' }}</td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.rankings.show', $ranking->id) }}" class="btn btn-info btn-sm">Ver Ranking</a> <!-- Novo botão para visualizar -->
                                        <a href="{{ route('admin.rankings.edit', $ranking->id) }}" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="{{ route('admin.rankings.destroy', $ranking->id) }}">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $rankings->appends(request()->query())->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este ranking?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
