@extends('layouts.app')
@section('title')
    Editar Ranking
@endsection
@section('content')
    <x-page-title title="Rankings" subtitle="Editar Ranking" />

    <div class="card mt-4">
        <div class="card-body">
            <form id="ranking-form" action="{{ route('admin.rankings.update', $ranking->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="mb-4">
                    <label for="name" class="form-label">Nome</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ old('name', $ranking->name) }}" required>
                </div>
                <div class="mb-4">
                    <label for="type" class="form-label">Tipo de Ranking</label>
                    <select name="type" id="type" class="form-select" required>
                        <option value="position" {{ old('type', $ranking->type) == 'position' ? 'selected' : '' }}>Por Posição</option>
                        <option value="goal" {{ old('type', $ranking->type) == 'goal' ? 'selected' : '' }}>Por Meta</option>
                    </select>
                </div>
                <div class="mb-4">
                    <label for="start_date" class="form-label">Data de Início</label>
                    <input type="date" name="start_date" id="start_date" class="form-control" value="{{ old('start_date', $ranking->start_date ? $ranking->start_date->format('Y-m-d') : '') }}" required>
                </div>
                <div class="mb-4">
                    <label for="end_date" class="form-label">Data de Fim</label>
                    <input type="date" name="end_date" id="end_date" class="form-control" value="{{ old('end_date', $ranking->end_date ? $ranking->end_date->format('Y-m-d') : '') }}" required>
                </div>
    
                <div class="mb-4" id="image-upload-container" @if($ranking->image) style="display: none;" @endif>
                    <label for="featured_image" class="form-label">Imagem Destacada</label>
                    <input id="featured-image-upload" type="file" name="files[]" accept="image/*">
                    <input type="hidden" name="featured_image_id" id="featured_image_id" value="{{ old('featured_image_id', $ranking->featured_image_id) }}">
                </div>
                
                <div id="image-preview-container" class="mb-4" @if(!$ranking->image) style="display: none;" @endif>
                    <label class="form-label">Imagem Destacada</label>
                    <div id="image-preview">
                        @if($ranking->image)
                            <img src="{{ Storage::url($ranking->image->path) }}" class="img-fluid" alt="Imagem Destacada">
                        @endif
                    </div>
                    <button type="button" id="remove-image" class="btn btn-danger btn-sm remove-image mt-2">Remover Imagem</button>
                </div>

                <div class="mb-4">
                    <label for="description" class="form-label">Descrição</label>
                    <textarea name="description" id="description" class="form-control">{{ old('description', $ranking->description) }}</textarea>
                </div>
                
                <div class="mb-4">
                    <label for="is_active" class="form-label">Ativo</label>
                    <select name="is_active" id="is_active" class="form-select" required>
                        <option value="1" {{ old('is_active', $ranking->is_active) == 1 ? 'selected' : '' }}>Sim</option>
                        <option value="0" {{ old('is_active', $ranking->is_active) == 0 ? 'selected' : '' }}>Não</option>
                    </select>
                </div>                

                <!-- Section to manage rewards -->
                <div class="mb-4">
                    <h5>Prêmios</h5>
                    <div id="rewards-container">
                        @foreach($ranking->rewards as $index => $reward)
                            <div class="reward-item mb-4" data-index="{{ $index }}">
                                <h6>Prêmio {{ $index + 1 }}</h6>
                                <div class="mb-3">
                                    <label for="rewards[{{ $index }}][name]" class="form-label">Nome do Prêmio</label>
                                    <input type="text" name="rewards[{{ $index }}][name]" class="form-control" value="{{ old('rewards.'.$index.'.name', $reward->name) }}" required>
                                </div>
                                <div id="reward-image-upload-container-{{ $index }}" class="mb-4" @if($reward->image) style="display: none;" @endif>
                                    <label for="reward-image-upload-{{ $index }}" class="form-label">Imagem do Prêmio</label>
                                    <input id="reward-image-upload-{{ $index }}" type="file" name="files[]" accept="image/*" class="reward-image-upload" data-index="{{ $index }}">
                                    <input type="hidden" name="rewards[{{ $index }}][image_id]" id="reward_image_id_{{ $index }}" value="{{ old('rewards.'.$index.'.image_id', $reward->image_id) }}">
                                </div>
                                <div id="reward-image-preview-container-{{ $index }}" class="mb-4" @if(!$reward->image) style="display: none;" @endif>
                                    <label class="form-label">Imagem do Prêmio</label>
                                    <div id="reward-image-preview-{{ $index }}">
                                        @if($reward->image)
                                            <img src="{{ Storage::url($reward->image->path) }}" class="img-fluid" alt="Imagem do Prêmio">
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-danger mt-2 remove-reward-image btn-sm remove-image " data-index="{{ $index }}">Remover Imagem</button>
                                </div>
                                <div class="mb-3 points-required" style="display: {{ old('type', $ranking->type) == 'goal' ? 'block' : 'none' }};">
                                    <label for="rewards[{{ $index }}][points_required]" class="form-label">Pontos Necessários</label>
                                    <input type="number" name="rewards[{{ $index }}][points_required]" class="form-control" value="{{ old('rewards.'.$index.'.points_required', $reward->points_required) }}">
                                </div>
                                <div class="mb-3 position-required" style="display: {{ old('type', $ranking->type) == 'position' ? 'block' : 'none' }};">
                                    <label for="rewards[{{ $index }}][position_required]" class="form-label">Posição Necessária</label>
                                    <input type="number" name="rewards[{{ $index }}][position_required]" class="form-control" value="{{ old('rewards.'.$index.'.position_required', $reward->position_required) }}">
                                </div>
                                <button type="button" class="btn btn-danger remove-reward">Remover Prêmio</button>
                                <hr>
                            </div>
                        @endforeach
                    </div>
                    <button type="button" id="add-reward" class="btn btn-secondary">Adicionar Prêmio</button>
                </div>

                <button type="submit" class="btn btn-primary">Salvar</button>
            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/l4r47ravfqp5up5il7sgqu6hc9qfyvfkwpxqks5p0sr319xk/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <script>
        tinymce.init({
            selector: '#description',
            skin: 'oxide-dark',
            content_css: 'dark',
            plugins: 'link',
            toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link',
            menubar: false,
            language: 'pt_BR',
            setup: function (editor) {
                editor.on('change', function () {
                    editor.save();
                });
            }
        });

        document.getElementById('ranking-form').addEventListener('submit', function() {
            tinymce.triggerSave();
            $(window).off('beforeunload');  // Desativa o alerta ao submeter o formulário
        });

        let rewardIndex = {{ $ranking->rewards->count() }};

        function addRewardField() {
            rewardIndex++;
            let rewardFieldset = `
                <div class="reward-item mb-4" data-index="${rewardIndex}">
                    <h6>Prêmio ${rewardIndex}</h6>
                    <div class="mb-3">
                        <label for="rewards[${rewardIndex}][name]" class="form-label">Nome do Prêmio</label>
                        <input type="text" name="rewards[${rewardIndex}][name]" class="form-control" required>
                    </div>
                    <div id="reward-image-upload-container-${rewardIndex}" class="mb-4">
                        <label for="reward-image-upload-${rewardIndex}" class="form-label">Imagem do Prêmio</label>
                        <input id="reward-image-upload-${rewardIndex}" type="file" name="files[]" accept="image/*" class="reward-image-upload" data-index="${rewardIndex}">
                        <input type="hidden" name="rewards[${rewardIndex}][image_id]" id="reward_image_id_${rewardIndex}">
                    </div>
                    <div id="reward-image-preview-container-${rewardIndex}" class="mb-4" style="display:none;">
                        <label class="form-label">Imagem do Prêmio</label>
                        <div id="reward-image-preview-${rewardIndex}"></div>
                        <button type="button" class="btn btn-danger mt-2 remove-reward-image" data-index="${rewardIndex}">Remover Imagem</button>
                    </div>
                    <div class="mb-3 points-required" style="display: none;">
                        <label for="rewards[${rewardIndex}][points_required]" class="form-label">Pontos Necessários</label>
                        <input type="number" name="rewards[${rewardIndex}][points_required]" class="form-control">
                    </div>
                    <div class="mb-3 position-required" style="display: none;">
                        <label for="rewards[${rewardIndex}][position_required]" class="form-label">Posição Necessária</label>
                        <input type="number" name="rewards[${rewardIndex}][position_required]" class="form-control">
                    </div>
                    <button type="button" class="btn btn-danger remove-reward">Remover Prêmio</button>
                    <hr>
                </div>`;
            $('#rewards-container').append(rewardFieldset);
        }

        // Delegação do evento change ao document
        $(document).on('change', '.reward-image-upload', async function () {
            const fileInput = this;
            const index = $(this).data('index');
            const formData = new FormData();

            if (fileInput.files.length === 0) {
                console.error('Nenhum arquivo selecionado.');
                return;
            }

            console.log('Iniciando upload para o prêmio de índice:', index);

            formData.append('files[]', fileInput.files[0]);
            formData.append('_token', '{{ csrf_token() }}');

            try {
                const response = await fetch('{{ route("admin.rankings.upload") }}', {
                    method: 'POST',
                    body: formData,
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao enviar o arquivo:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    console.log('Upload concluído com sucesso para o prêmio de índice:', index);
                    $(`#reward_image_id_${index}`).val(responseData.image_id);
                    $(`#reward-image-upload-container-${index}`).hide();
                    $(`#reward-image-preview-container-${index}`).show();
                    $(`#reward-image-preview-${index}`).html('<img src="' + responseData.location + '" class="img-fluid" alt="Imagem do Prêmio">');
                } else {
                    console.error('Erro ao processar a resposta:', responseData);
                }
            } catch (error) {
                console.error('Erro ao enviar o arquivo:', error);
            }
        });

        function updateRewardFieldsVisibility() {
            const rankingType = $('#type').val();
            $('.reward-item').each(function() {
                const index = $(this).data('index');
                if (rankingType === 'goal') {
                    $(this).find('.points-required').show();
                    $(this).find('.position-required').hide();
                } else if (rankingType === 'position') {
                    $(this).find('.points-required').hide();
                    $(this).find('.position-required').show();
                }
            });
        }

        $(document).on('click', '.remove-reward', function() {
            $(this).closest('.reward-item').remove();
        });

        $(document).on('click', '.remove-reward-image', async function() {
            var index = $(this).data('index');
            var imageId = $(`#reward_image_id_${index}`).val();

            try {
                const response = await fetch('{{ route("admin.rankings.upload.destroy", '') }}/' + imageId, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao excluir a imagem:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    console.log('Imagem removida com sucesso para o prêmio de índice:', index);
                    $(`#reward_image_id_${index}`).val('');
                    $(`#reward-image-upload-container-${index}`).show();
                    $(`#reward-image-preview-container-${index}`).hide();
                    $(`#reward-image-preview-${index}`).html('');
                } else {
                    console.error('Erro ao excluir a imagem:', responseData);
                }
            } catch (error) {
                console.error('Erro ao excluir a imagem:', error);
            }
        });

        $('#type').on('change', function() {
            updateRewardFieldsVisibility();
        });

        $('#add-reward').on('click', function() {
            addRewardField();
        });

        $(document).ready(function() {
            $('#ranking-form input, #ranking-form select, #ranking-form textarea').on('change', function() {
                $('#ranking-form').data('changed', true);
            });

            $('#ranking-form').on('submit', function() {
                $('#ranking-form').data('changed', false);
            });

            updateRewardFieldsVisibility();
        });

        document.getElementById('featured-image-upload').addEventListener('change', async function () {
            const fileInput = this;
            const formData = new FormData();

            if (fileInput.files.length === 0) {
                console.error('Nenhum arquivo selecionado.');
                return;
            }

            console.log('Iniciando upload da imagem destacada');

            formData.append('files[]', fileInput.files[0]);
            formData.append('_token', '{{ csrf_token() }}');

            try {
                const response = await fetch('{{ route("admin.rankings.upload") }}', {
                    method: 'POST',
                    body: formData,
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao enviar o arquivo:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    console.log('Upload da imagem destacada concluído com sucesso');
                    document.getElementById('featured_image_id').value = responseData.image_id;
                    document.getElementById('image-upload-container').style.display = 'none';
                    document.getElementById('image-preview-container').style.display = 'block';
                    document.getElementById('image-preview').innerHTML = '<img src="' + responseData.location + '" class="img-fluid" alt="Imagem Destacada">';
                } else {
                    console.error('Erro ao processar a resposta:', responseData);
                }
            } catch (error) {
                console.error('Erro ao enviar o arquivo:', error);
            }
        });

        document.getElementById('remove-image').addEventListener('click', async function () {
            var imageId = document.getElementById('featured_image_id').value;

            try {
                const response = await fetch('{{ route("admin.rankings.upload.destroy", '') }}/' + imageId, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao excluir a imagem:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    console.log('Imagem destacada removida com sucesso');
                    document.getElementById('featured_image_id').value = '';
                    document.getElementById('image-upload-container').style.display = 'block';
                    document.getElementById('image-preview-container').style.display = 'none';
                    document.getElementById('image-preview').innerHTML = '';
                } else {
                    console.error('Erro ao excluir a imagem:', responseData);
                }
            } catch (error) {
                console.error('Erro ao excluir a imagem:', error);
            }
        });
    </script>
@endsection

@push('css')
    <link href="{{ URL::asset('build/plugins/fancy-file-uploader/fancy_fileupload.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
