@extends('layouts.app')
@section('title')
    Criar Ranking
@endsection
@section('content')
    <x-page-title title="Rankings" subtitle="Criar Ranking" />

    <div class="card mt-4">
        <div class="card-body">
            <form id="ranking-form" action="{{ route('admin.rankings.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-4">
                    <label for="name" class="form-label">Nome</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}" required>
                </div>
                <div class="mb-4">
                    <label for="type" class="form-label">Tipo de Ranking</label>
                    <select name="type" id="type" class="form-select" required>
                        <option value="position" {{ old('type') == 'position' ? 'selected' : '' }}>Por Posição</option>
                        <option value="goal" {{ old('type') == 'goal' ? 'selected' : '' }}>Por Meta</option>
                    </select>
                </div>
                <div class="mb-4">
                    <label for="start_date" class="form-label">Data de Início</label>
                    <input type="date" name="start_date" id="start_date" class="form-control" value="{{ old('start_date') }}" required>
                </div>
                <div class="mb-4">
                    <label for="end_date" class="form-label">Data de Fim</label>
                    <input type="date" name="end_date" id="end_date" class="form-control" value="{{ old('end_date') }}" required>
                </div>
                <div class="mb-4" id="image-upload-container">
                    <label for="featured_image" class="form-label">Imagem Destacada</label>
                    <input id="featured-image-upload" type="file" name="files[]" accept="image/*">
                    <input type="hidden" name="featured_image_id" id="featured_image_id">
                </div>
                <div id="image-preview-container" class="mb-4" style="display:none;">
                    <label class="form-label">Imagem Destacada</label>
                    <div id="image-preview"></div>
                    <button type="button" id="remove-image" class="btn btn-danger mt-2 btn-sm remove-image">Remover Imagem</button>
                </div>
                <div class="mb-4">
                    <label for="description" class="form-label">Descrição</label>
                    <textarea name="description" id="description" class="form-control">{{ old('description') }}</textarea>
                </div>
                
                <div class="mb-4">
                    <label for="is_active" class="form-label">Ativo</label>
                    <select name="is_active" id="is_active" class="form-select" required>
                        <option value="1" {{ old('is_active') == 1 ? 'selected' : '' }}>Sim</option>
                        <option value="0" {{ old('is_active') == 0 ? 'selected' : '' }}>Não</option>
                    </select>
                </div>                

                <!-- Section to add rewards -->
                <div class="mb-4">
                    <h5>Prêmios</h5>
                    <div id="rewards-container">
                        <!-- Rewards fields will be added here dynamically -->
                    </div>
                    <button type="button" id="add-reward" class="btn btn-secondary">Adicionar Prêmio</button>
                </div>

                <button type="submit" class="btn btn-primary">Salvar</button>
            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/l4r47ravfqp5up5il7sgqu6hc9qfyvfkwpxqks5p0sr319xk/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <script>
        tinymce.init({
            selector: '#description',
            skin: 'oxide-dark',
            content_css: 'dark',
            plugins: 'link',
            toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link',
            menubar: false,
            language: 'pt_BR',
            setup: function (editor) {
                editor.on('change', function () {
                    editor.save();
                });
            }
        });

        document.getElementById('ranking-form').addEventListener('submit', function() {
            tinymce.triggerSave();
            $(window).off('beforeunload');  // Desativa o alerta ao submeter o formulário
        });

        window.addEventListener('beforeunload', function (e) {
            if ($('#ranking-form').data('changed')) {
                var confirmationMessage = 'É possível que as alterações feitas não sejam salvas.';
                (e || window.event).returnValue = confirmationMessage;
                return confirmationMessage;
            }
        });

        let rewardIndex = 0;

        // Function to add a new reward fieldset
        function addRewardField() {
            rewardIndex++;
            let rewardFieldset = `
                <div class="reward-item mb-4" data-index="${rewardIndex}">
                    <h6>Prêmio ${rewardIndex}</h6>
                    <div class="mb-3">
                        <label for="rewards[${rewardIndex}][name]" class="form-label">Nome do Prêmio</label>
                        <input type="text" name="rewards[${rewardIndex}][name]" class="form-control" required>
                    </div>
                    <div id="reward-image-upload-container-${rewardIndex}" class="mb-4">
                        <label for="reward-image-upload-${rewardIndex}" class="form-label">Imagem do Prêmio</label>
                        <input id="reward-image-upload-${rewardIndex}" type="file" name="files[]" accept="image/*" class="reward-image-upload" data-index="${rewardIndex}">
                        <input type="hidden" name="rewards[${rewardIndex}][image_id]" id="reward_image_id_${rewardIndex}">
                    </div>
                    <div id="reward-image-preview-container-${rewardIndex}" class="mb-4" style="display:none;">
                        <label class="form-label">Imagem do Prêmio</label>
                        <div id="reward-image-preview-${rewardIndex}"></div>
                        <button type="button" class="btn btn-danger mt-2 remove-reward-image btn-sm remove-image" data-index="${rewardIndex}">Remover Imagem</button>
                    </div>
                    <div class="mb-3 points-required" style="display: none;">
                        <label for="rewards[${rewardIndex}][points_required]" class="form-label">Pontos Necessários</label>
                        <input type="number" name="rewards[${rewardIndex}][points_required]" class="form-control">
                    </div>
                    <div class="mb-3 position-required" style="display: none;">
                        <label for="rewards[${rewardIndex}][position_required]" class="form-label">Posição Necessária</label>
                        <input type="number" name="rewards[${rewardIndex}][position_required]" class="form-control">
                    </div>
                    <button type="button" class="btn btn-danger remove-reward">Remover Prêmio</button>
                    <hr>
                </div>`;
            $('#rewards-container').append(rewardFieldset);

            // Configurar upload de arquivo manualmente via fetch
            setupManualFileUpload(rewardIndex);

            // Atualizar visibilidade dos campos com base no tipo selecionado
            updateRewardFieldsVisibility();
        }

        // Function to setup manual file upload via fetch
        function setupManualFileUpload(index) {
            $(`#reward-image-upload-${index}`).on('change', async function () {
                const fileInput = this;
                const formData = new FormData();
                
                // Verifica se um arquivo foi selecionado
                if (fileInput.files.length === 0) {
                    console.error('Nenhum arquivo selecionado.');
                    return;
                }

                formData.append('files[]', fileInput.files[0]);  // Corrigido para 'files[]'
                formData.append('_token', '{{ csrf_token() }}');

                try {
                    const response = await fetch('{{ route("admin.rankings.upload") }}', {
                        method: 'POST',
                        body: formData,
                    });

                    if (!response.ok) {
                        const errorData = await response.json();
                        console.error('Erro ao enviar o arquivo:', errorData);
                        return;
                    }

                    const responseData = await response.json();

                    if (responseData.success) {
                        $(`#reward_image_id_${index}`).val(responseData.image_id);
                        $(`#reward-image-upload-container-${index}`).hide();
                        $(`#reward-image-preview-container-${index}`).show();
                        $(`#reward-image-preview-${index}`).html('<img src="' + responseData.location + '" class="img-fluid" alt="Imagem do Prêmio">');
                    } else {
                        console.error('Erro ao processar a resposta: ', responseData);
                    }
                } catch (error) {
                    console.error('Erro ao enviar o arquivo:', error);
                }
            });
        }

        // Function to update reward fields visibility based on ranking type
        function updateRewardFieldsVisibility() {
            const rankingType = $('#type').val();
            $('.reward-item').each(function() {
                const index = $(this).data('index');
                if (rankingType === 'goal') {
                    $(this).find('.points-required').show();
                    $(this).find('.position-required').hide();
                } else if (rankingType === 'position') {
                    $(this).find('.points-required').hide();
                    $(this).find('.position-required').show();
                }
            });
        }

        // Remove reward field
        $(document).on('click', '.remove-reward', function() {
            $(this).closest('.reward-item').remove();
        });

        // Handle image removal for rewards
        $(document).on('click', '.remove-reward-image', async function() {
            var index = $(this).data('index');
            var imageId = $(`#reward_image_id_${index}`).val();
            
            try {
                const response = await fetch('{{ route("admin.rankings.upload.destroy", '') }}/' + imageId, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao excluir a imagem:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    $(`#reward_image_id_${index}`).val('');
                    $(`#reward-image-upload-container-${index}`).show();
                    $(`#reward-image-preview-container-${index}`).hide();
                    $(`#reward-image-preview-${index}`).html('');
                } else {
                    console.error('Erro ao excluir a imagem: ', responseData);
                }
            } catch (error) {
                console.error('Erro ao excluir a imagem:', error);
            }
        });

        // Update visibility of reward fields based on ranking type selection
        $('#type').on('change', function() {
            updateRewardFieldsVisibility();
        });

        // Add reward field when clicking the button
        $('#add-reward').on('click', function() {
            addRewardField();
        });

        // Initialize the form
        $(document).ready(function() {
            $('#ranking-form input, #ranking-form select, #ranking-form textarea').on('change', function() {
                $('#ranking-form').data('changed', true);
            });

            $('#ranking-form').on('submit', function() {
                $('#ranking-form').data('changed', false);
            });

            // Initialize the first reward field if needed
            @if(old('rewards'))
                @foreach(old('rewards') as $index => $reward)
                    addRewardField();
                @endforeach
            @endif

            // Set initial visibility of fields based on selected ranking type
            updateRewardFieldsVisibility();
        });

        // Handle image upload for the main image
        document.getElementById('featured-image-upload').addEventListener('change', async function () {
            const fileInput = this;
            const formData = new FormData();

            // Verifica se um arquivo foi selecionado
            if (fileInput.files.length === 0) {
                console.error('Nenhum arquivo selecionado.');
                return;
            }

            formData.append('files[]', fileInput.files[0]);  // Corrigido para 'files[]'
            formData.append('_token', '{{ csrf_token() }}');

            try {
                const response = await fetch('{{ route("admin.rankings.upload") }}', {
                    method: 'POST',
                    body: formData,
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao enviar o arquivo:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    document.getElementById('featured_image_id').value = responseData.image_id;
                    document.getElementById('image-upload-container').style.display = 'none';
                    document.getElementById('image-preview-container').style.display = 'block';
                    document.getElementById('image-preview').innerHTML = '<img src="' + responseData.location + '" class="img-fluid" alt="Imagem Destacada">';
                } else {
                    console.error('Erro ao processar a resposta: ', responseData);
                }
            } catch (error) {
                console.error('Erro ao enviar o arquivo:', error);
            }
        });

        // Handle image removal for the main image
        document.getElementById('remove-image').addEventListener('click', async function () {
            var imageId = document.getElementById('featured_image_id').value;

            try {
                const response = await fetch('{{ route("admin.rankings.upload.destroy", '') }}/' + imageId, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    console.error('Erro ao excluir a imagem:', errorData);
                    return;
                }

                const responseData = await response.json();

                if (responseData.success) {
                    document.getElementById('featured_image_id').value = '';
                    document.getElementById('image-upload-container').style.display = 'block';
                    document.getElementById('image-preview-container').style.display = 'none';
                    document.getElementById('image-preview').innerHTML = '';
                } else {
                    console.error('Erro ao excluir a imagem: ', responseData);
                }
            } catch (error) {
                console.error('Erro ao excluir a imagem:', error);
            }
        });
    </script>
@endsection



@push('css')
    <link href="{{ URL::asset('build/plugins/fancy-file-uploader/fancy_fileupload.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
