@extends('layouts.app')
@section('title')
    Pontos
@endsection
@section('content')
    <x-page-title title="Pontos" subtitle="Lista de Pontos" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex justify-content-between align-items-end gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <form method="GET" action="{{ route('admin.points.index') }}" class="d-flex align-items-end gap-2 flex-wrap">
            <div>
                <label for="architect_id" class="form-label">Arquiteto</label>
                <select name="architect_id" id="architect_id" class="form-select">
                    <option value="">Todos os Arquitetos</option>
                    @foreach($architects as $architect)
                        <option value="{{ $architect->id }}" {{ request('architect_id') == $architect->id ? 'selected' : '' }}>
                            {{ $architect->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <!-- Novo Filtro por Loja -->
            <div>
                <label for="store_id" class="form-label">Loja</label>
                <select name="store_id" id="store_id" class="form-select">
                    <option value="">Todas as Lojas</option>
                    @foreach($stores as $store)
                        <option value="{{ $store->id }}" {{ request('store_id') == $store->id ? 'selected' : '' }}>
                            {{ $store->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        
            <div>
                <label for="start_date" class="form-label">Data Inicial</label>
                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="form-control">
            </div>
            <div>
                <label for="end_date" class="form-label">Data Final</label>
                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="form-control">
            </div>
            <div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
        </form>        
        <a href="{{ route('admin.points.create') }}" class="btn btn-success"><i class="bi bi-plus-lg me-2"></i>Atribuir Pontos</a>
    </div>

    <!-- Filtros Ativos -->
    <!-- Filtros Ativos -->
    <div class="mb-4">
        @if(request('architect_id'))
            <span class="badge bg-info text-dark">
                Arquiteto: {{ $architects->find(request('architect_id'))->name }}
                <a href="{{ route('admin.points.index', array_merge(request()->except('architect_id'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif

        @if(request('store_id'))
            <span class="badge bg-info text-dark">
                Loja: {{ $stores->find(request('store_id'))->name }}
                <a href="{{ route('admin.points.index', array_merge(request()->except('store_id'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif

        @if(request('start_date'))
            <span class="badge bg-info text-dark">
                Data Inicial: {{ request('start_date') }}
                <a href="{{ route('admin.points.index', array_merge(request()->except('start_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif

        @if(request('end_date'))
            <span class="badge bg-info text-dark">
                Data Final: {{ request('end_date') }}
                <a href="{{ route('admin.points.index', array_merge(request()->except('end_date'), ['page' => 1])) }}" class="text-dark ms-1">&times;</a>
            </span>
        @endif
    </div>


    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Arquiteto</th>
                                <th>Pontos</th>
                                <th>Valor da Venda</th>
                                <th>Regra de Pontuação</th> <!-- Nova coluna -->

                                <th>Nome do Cliente</th>
                                <th>Loja</th> <!-- Nova Coluna de Loja -->
                                <th>Data</th>
                                <th class="text-right">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($points as $point)
                                <tr>
                                    <td>{{ $point->architect->name }}</td>
                                    <td>{{ number_format($point->points, 0, ',', '.') }}</td>
                                    <td>{{ 'R$ ' . number_format($point->sale_value, 2, ',', '.') }}</td>
                                    <td>{{ $point->scoring_rule_name }}</td> <!-- Exibe a regra de pontuação -->
                                    <td>{{ $point->customer_name }}</td>
                                    <td>{{ $point->store->name ?? 'N/A' }}</td> <!-- Exibição da loja -->
                                    <td>{{ $point->created_at->format('d/m/Y') }}</td>
                                    <td class="text-right">
                                        <a href="{{ route('admin.points.edit', $point->id) }}" class="btn btn-warning btn-sm">Editar</a>
                                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-action="{{ route('admin.points.destroy', $point->id) }}">
                                            Excluir
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="rodape-tabela">
                                <th>Total</th>
                                <th>{{ number_format($totalPoints, 0, ',', '.') }}</th>
                                <th>{{ 'R$ ' . number_format($totalSaleValue, 2, ',', '.') }}</th>
                                <th colspan="7"></th>
                            </tr>
                        </tfoot>
                    </table>                    
                </div>
                <div class="mt-4">
                    <p><strong>Total de registros:</strong> {{ $points->total() }}</p> <!-- Exibe o total de registros -->
                    {{ $points->appends(request()->query())->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este ponto?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
