@extends('layouts.app')
@section('title')
    Gerenciar Imagens
@endsection
@section('content')
    <x-page-title title="Imagens" subtitle="Gerenciar Imagens" />

    <div class="card mt-4">
        <div class="card-body">
            <div class="mb-4">
                <h3 class="text-lg font-medium text-gray-700">Imagens</h3>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th scope="col" class="text-center">Thumbnail</th>
                            <th scope="col">Caminho</th>
                            <th scope="col" class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($images as $image)
                            <tr>
                                <td class="text-center">
                                    <img src="{{ Storage::url($image->path) }}" alt="{{ $image->filename }}" class="img-thumbnail" style="width: 100px; height: 100px;">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="text" value="{{ Storage::url($image->path) }}" class="form-control" readonly>
                                        <button class="btn btn-primary" onclick="copyToClipboard('{{ Storage::url($image->path) }}')">Copiar</button>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal" data-image-id="{{ $image->id }}">Excluir</button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $images->links('pagination::bootstrap-4') }}
            </div>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir esta imagem?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteButton">Excluir</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function copyToClipboard(url) {
            navigator.clipboard.writeText(url).then(function() {
                alert('URL copiado para a área de transferência.');
            }, function(err) {
                alert('Erro ao copiar o URL: ', err);
            });
        }

        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            var confirmDeleteButton = document.getElementById('confirmDeleteButton');
            var imageIdToDelete;

            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                imageIdToDelete = button.getAttribute('data-image-id');
            });

            confirmDeleteButton.addEventListener('click', function () {
                if (imageIdToDelete) {
                    fetch(`/admin/images/${imageIdToDelete}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert('Erro ao excluir a imagem.');
                        }
                    });
                }
            });
        });
    </script>
@endsection

@push('script')
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
