@extends('layouts.app')
@section('title')
    Detalhes do Arquiteto
@endsection
@section('content')
    <x-page-title title="Detalhes do Arquiteto" subtitle="{{ $architect->name }}" />

    @if (session('success'))
        <div class="alert alert-success" role="alert">
            {{ session('success') }}
        </div>
    @endif

    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('admin.architects.assignPoints', $architect->id) }}" class="btn btn-success me-2">Atribuir Pontos</a>
        <a href="{{ route('admin.architects.edit', $architect->id) }}" class="btn btn-warning me-2">Editar Arquiteto</a>
        <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">Deletar Arquiteto</button>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <h5>Informações Pessoais</h5>
            <p><strong>Nome:</strong> {{ $architect->name }}</p>
            <p><strong>Email:</strong> {{ $architect->email }}</p>
            <p><strong>Telefone:</strong> {{ $architect->architectProfile->phone ?? 'N/A' }}</p>
            <p><strong>Data de Nascimento:</strong> @if($architect->architectProfile && $architect->architectProfile->birth_date)
                {{ \Carbon\Carbon::parse($architect->architectProfile->birth_date)->format('d/m/Y') }}
            @else
                N/A
            @endif</p>
        </div>
    </div>

    <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-success text-success bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">{{ $pointsThisMonth }}</h4>
                            <p class="mb-0">Pontos Ganhos No Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-danger text-danger bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">diamond</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">{{ $pointsThisYear }}</h4>
                            <p class="mb-0">Pontos Ganhos No Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-info text-info bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ {{ number_format($salesThisMonth, 2, ',', '.') }}</h4>
                            <p class="mb-0">Valor em Vendas no Mês</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card rounded-4 mb-0">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-3">
                        <div
                            class="wh-48 d-flex bg-orange-light text-orange bg-opacity-10 align-items-center justify-content-center rounded-circle">
                            <span class="material-icons-outlined">shopping_cart</span>
                        </div>
                        <div class="">
                            <h4 class="mb-0">R$ {{ number_format($salesThisYear, 2, ',', '.') }}</h4>
                            <p class="mb-0">Valor em Vendas no Ano</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->
    
    <div class="card mt-4">
        <div class="card-body">
            <h5>Pontos Atribuídos</h5>
            <table class="table table-dark table-striped">
                <thead>
                    <tr>
                        <th>Pontos</th>
                        <th>Valor da Venda</th>
                        <th>Nome do Cliente</th>
                        <th>Descrição</th>
                        <th>Data</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($architect->points as $point)
                        <tr>
                            <td>{{ $point->points }}</td>
                            <td>R$ {{ number_format($point->sale_value, 2, ',', '.') }}</td>
                            <td>{{ $point->customer_name }}</td>
                            <td>{{ $point->description }}</td>
                            <td>{{ \Carbon\Carbon::parse($point->created_at)->format('d/m/Y') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tem certeza que deseja excluir este arquiteto?
                </div>
                <div class="modal-footer">
                    <form method="POST" action="{{ route('admin.architects.destroy', $architect->id) }}">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Excluir</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
