@extends('layouts.app')
@section('title')
    Arquitetos
@endsection
@section('content')
    <x-page-title title="Arquitetos" subtitle="Lista de Arquitetos" />

    @if (session('message'))
        <div class="alert alert-success" role="alert">
            {{ session('message') }}
        </div>
    @endif

    <div class="d-flex align-items-center gap-3 gap-lg-4 mb-4 fw-bold flex-wrap font-text1">
        <a href="{{ route('admin.architects.index') }}">
            <span class="me-1">Arquitetos</span>
            <span class="text-secondary">({{ $totalArchitects }})</span>
        </a>
    </div>

    <div class="row g-3 justify-content-between">
        <div class="col-auto">
            <div class="position-relative">
                <form method="GET" action="{{ route('admin.architects.index') }}" class="d-flex align-items-center">
                    <input class="form-control px-5" type="search" name="search" placeholder="Buscar Arquitetos" value="{{ request('search') }}">
                    <span class="material-icons-outlined position-absolute ms-3 translate-middle-y start-0 top-50 fs-5">search</span>
                </form>
            </div>
        </div>
        <div class="col-auto">
            <div class="d-flex align-items-center gap-2 justify-content-lg-end">
                <a href="{{ route('admin.architects.create') }}" class="btn btn-primary px-4"><i class="bi bi-plus-lg me-2"></i>Criar Novo Arquiteto</a>
            </div>
        </div>
    </div><!--end row-->

    <div class="card mt-4">
        <div class="card-body">
            <div class="customer-table">
                <div class="table-responsive white-space-nowrap">
                    <table class="table mb-0 table-dark table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Telefone</th>
                                <th>Data de Nascimento</th>
                                <th class="text-end">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($architects as $architect)
                                <tr>
                                    <td>{{ $architect->name }}</td>
                                    <td>{{ $architect->email }}</td>
                                    
                                    <td>{{ optional($architect->architectProfile)->phone }}</td>
                                    <td>
                                        @if($architect->architectProfile && $architect->architectProfile->birth_date)
                                            {{ \Carbon\Carbon::parse($architect->architectProfile->birth_date)->format('d/m/Y') }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.architects.show', $architect->id) }}" class="btn btn-info btn-sm">Ver Arquiteto</a>
                                        <a href="{{ route('admin.architects.assignPoints', $architect->id) }}" class="btn btn-success btn-sm">Atribuir Pontos</a>
                                    </td>                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $architects->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var deleteModal = document.getElementById('deleteModal');
            deleteModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var action = button.getAttribute('data-action');
                var deleteForm = deleteModal.querySelector('#deleteForm');
                deleteForm.setAttribute('action', action);
            });
        });
    </script>
@endsection

@push('script')
    <!--plugins-->
    <script src="{{ URL::asset('build/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/metismenu/metisMenu.min.js') }}"></script>
    <script src="{{ URL::asset('build/plugins/simplebar/js/simplebar.min.js') }}"></script>
    <script src="{{ URL::asset('build/js/main.js') }}"></script>
@endpush
