<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('reward_redemptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('architect_id')->constrained('users')->onDelete('cascade'); // Supondo que arquitetos são usuários
            $table->foreignId('ranking_reward_id')->constrained('ranking_rewards')->onDelete('cascade');
            $table->timestamp('redeemed_at');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('reward_redemptions');
    }
};
