<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('ranking_rewards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ranking_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->foreignId('image_id')->nullable()->constrained('images')->onDelete('set null');
            $table->integer('points_required')->nullable(); // Para ranking de meta
            $table->integer('position_required')->nullable(); // Para ranking de posição
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ranking_rewards');
    }
};
