<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('store_manager_profiles', function (Blueprint $table) {
            // Adicionar a coluna user_id antes de store_id
            $table->unsignedBigInteger('user_id')->after('id');

            // Renomear a coluna loja_id para store_id
            $table->renameColumn('loja_id', 'store_id');

            // Adicionar as chaves estrangeiras
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('store_id')->references('id')->on('stores')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('store_manager_profiles', function (Blueprint $table) {
            // Remover as chaves estrangeiras
            $table->dropForeign(['user_id']);
            $table->dropForeign(['store_id']);

            // Renomear a coluna store_id de volta para loja_id
            $table->renameColumn('store_id', 'loja_id');

            // Remover a coluna user_id
            $table->dropColumn('user_id');
        });
    }
};
