<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('rankings', function (Blueprint $table) {
            $table->unsignedBigInteger('featured_image_id')->nullable()->after('is_active');
            $table->foreign('featured_image_id')->references('id')->on('images')->onDelete('set null');
            $table->dropColumn('featured_image');
        });
    }

    public function down()
    {
        Schema::table('rankings', function (Blueprint $table) {
            $table->string('featured_image')->nullable()->after('is_active');
            $table->dropForeign(['featured_image_id']);
            $table->dropColumn('featured_image_id');
        });
    }
};
