<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('points', function (Blueprint $table) {
            $table->id();
            $table->foreignId('architect_id')->constrained('users')->onDelete('cascade'); // Assumindo que a tabela de usuários se chama 'users'
            $table->foreignId('admin_id')->constrained('users')->onDelete('cascade'); // Assumindo que a tabela de usuários se chama 'users'
            $table->integer('points');
            $table->decimal('sale_value', 8, 2);
            $table->string('customer_name');
            $table->text('description');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('points');
    }
};
