<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StoreManagerProfile extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'store_id', 'phone'];

    // Relacionamento com o usuário (gerente de loja)
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relacionamento com a loja
    public function store()
    {
        return $this->belongsTo(Store::class);
    }
}
