<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Store extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'rua',
        'numero',
        'cep',
        'bairro',
        'cidade',
        'estado',
        'telefone',
        'email',
        'instagram',
        'image_id',
    ];

    public function image()
    {
        return $this->belongsTo(Image::class);
    }

    public function storeManagerProfiles()
    {
        return $this->hasMany(StoreManagerProfile::class);
    }
    
    public function points()
    {
        return $this->hasMany(Point::class);
    }
}
