<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScoringRule extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'scoring_rules';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'amount_spent_per_point',
        'is_active',
        'is_featured',
        'admin_id',
    ];

    /**
     * Get the admin that created the scoring rule.
     */
    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }

    public function points()
    {
        return $this->hasMany(Point::class);
    }
}
