<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RewardRedemption extends Model
{
    use HasFactory;

    protected $fillable = [
        'architect_id',
        'ranking_reward_id',
        'redeemed_at',
    ];

    public function architect()
    {
        return $this->belongsTo(User::class, 'architect_id');
    }

    public function reward()
    {
        return $this->belongsTo(RankingReward::class, 'ranking_reward_id');
    }
}
