<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RankingReward extends Model
{
    use HasFactory;

    protected $fillable = [
        'ranking_id',
        'name',
        'image_id',
        'points_required',
        'position_required',
    ];

    public function ranking()
    {
        return $this->belongsTo(Ranking::class);
    }

    public function image()
    {
        return $this->belongsTo(Image::class);
    }
}
