<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ranking extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'start_date',
        'end_date',
        'is_active',
        'featured_image_id',
        'admin_id',
        'type',
    ];

    public function image()
    {
        return $this->belongsTo(Image::class, 'featured_image_id');
    }

    public function rewards()
    {
        return $this->hasMany(RankingReward::class);
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
    
    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];
}
