<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Point extends Model
{
    use HasFactory;

    protected $fillable = [
        'architect_id',
        'admin_id',
        'scoring_rule_id',
        'scoring_rule_name',
        'store_id',
        'points',
        'sale_value',
        'customer_name',
        'description',
    ];

    public function architect()
    {
        return $this->belongsTo(User::class, 'architect_id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
    public function scoringRule()
    {
        return $this->belongsTo(ScoringRule::class);
    }

    public function store()
    {
        return $this->belongsTo(Store::class);
    }
}
