<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ArchitectProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'cpf',
        'cep',
        'rua',
        'numero',
        'bairro',
        'cidade',
        'estado',
        'phone',
        'birth_date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected $dates = ['birth_date'];
}