<?php

namespace App\Http\Controllers\Manager;

use App\Http\Controllers\Controller;
use App\Models\Store;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StoreController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $stores = Store::paginate(10); // Paginação das lojas

        return view('manager.stores.index', compact('stores'));
    }

    // Exibe o formulário de edição da loja
    public function edit()
    {
        // Obtém a loja do gerente logado
        $store = Auth::user()->storeManagerProfile->store;

        return view('manager.stores.edit', compact('store'));
    }

    // Atualiza os dados da loja
    public function update(Request $request)
    {
        $store = Auth::user()->storeManagerProfile->store;

        $request->validate([
            'name' => 'required|string|max:255',
            'rua' => 'nullable|string|max:255',
            'numero' => 'nullable|string|max:50',
            'cep' => 'nullable|string|max:20',
            'bairro' => 'nullable|string|max:100',
            'cidade' => 'nullable|string|max:100',
            'estado' => 'nullable|string|max:50',
            'telefone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'instagram' => 'nullable|string|max:100',
            'image_id' => 'nullable|exists:images,id',
        ]);

        // Atualiza os dados da loja
        $store->update($request->all());

        return redirect()->route('manager.stores.index')->with('message', 'Loja atualizada com sucesso!');
    }
}