<?php

namespace App\Http\Controllers\Manager;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\ArchitectProfile;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;


class ArchitectController extends Controller
{
    public function index(Request $request)
    {
        $totalArchitects = User::where('role', 'architect')->count();

        $query = User::query()->where('role', 'architect');

        // Adicionar filtragem e busca
        if ($request->has('search') && $request->input('search') !== null) {
            $query->where(function ($q) use ($request) {
                $q->where('name', 'like', '%' . $request->input('search') . '%')
                    ->orWhere('email', 'like', '%' . $request->input('search') . '%');
            });
        }

        // Ordenar por nome em ordem alfabética
        $query->orderBy('name');

        $architects = $query->with('architectProfile')->paginate(10);

        return view('manager.architects.index', compact('architects', 'totalArchitects'));
    }


    public function show(User $architect)
    {
        $currentMonth = Carbon::now()->month;
        $currentYear = Carbon::now()->year;

        // Calcular pontos ganhos no mês (de todas as lojas)
        $pointsThisMonth = $architect->points()
            ->whereMonth('created_at', $currentMonth)
            ->whereYear('created_at', $currentYear)
            ->sum('points');

        // Calcular pontos ganhos no ano (de todas as lojas)
        $pointsThisYear = $architect->points()
            ->whereYear('created_at', $currentYear)
            ->sum('points');

        // Calcular valor de vendas no mês (de todas as lojas)
        $salesThisMonth = $architect->points()
            ->whereMonth('created_at', $currentMonth)
            ->whereYear('created_at', $currentYear)
            ->sum('sale_value');

        // Calcular valor de vendas no ano (de todas as lojas)
        $salesThisYear = $architect->points()
            ->whereYear('created_at', $currentYear)
            ->sum('sale_value');

        // Filtrar pontos atribuídos pela loja do gerente logado
        $storeId = auth()->user()->storeManagerProfile->store_id;
        $storePoints = $architect->points()
            ->where('store_id', $storeId)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('manager.architects.show', compact('architect', 'pointsThisMonth', 'pointsThisYear', 'salesThisMonth', 'salesThisYear', 'storePoints'));
    }


    

}