<?php

namespace App\Http\Controllers\Architect;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point;
use App\Models\Store; // Importar o modelo de Store
use Carbon\Carbon;

class PointsController extends Controller
{
    public function index(Request $request)
    {
        $query = Point::where('architect_id', auth()->id());

        // Filtros existentes
        if ($request->start_date) {
            $query->whereDate('created_at', '>=', $request->start_date);
        }

        if ($request->end_date) {
            $query->whereDate('created_at', '<=', $request->end_date);
        }

        if ($request->description) {
            $query->where('description', 'like', '%' . $request->description . '%');
        }

        if ($request->store_id) {
            $query->where('store_id', $request->store_id);
        }

        // Obter os pontos e vendas com os filtros
        $points = $query->with(['admin', 'store'])->orderBy('created_at', 'desc')->paginate(10);

        // Calcular somas para o footer da tabela
        $totalPoints = $query->sum('points');
        $totalSales = $query->sum('sale_value');

        // Calcular pontos e vendas do mês
        $currentMonth = Carbon::now()->month;
        $pointsThisMonth = Point::where('architect_id', auth()->id())
            ->whereMonth('created_at', $currentMonth)
            ->sum('points');

        $salesThisMonth = Point::where('architect_id', auth()->id())
            ->whereMonth('created_at', $currentMonth)
            ->sum('sale_value');

        // Calcular pontos e vendas do ano
        $currentYear = Carbon::now()->year;
        $pointsThisYear = Point::where('architect_id', auth()->id())
            ->whereYear('created_at', $currentYear)
            ->sum('points');

        $salesThisYear = Point::where('architect_id', auth()->id())
            ->whereYear('created_at', $currentYear)
            ->sum('sale_value');

        // Obter todas as lojas para o filtro
        $stores = Store::all();

        return view('architect.points.index', compact(
            'points', 
            'pointsThisMonth', 
            'pointsThisYear', 
            'salesThisMonth', 
            'salesThisYear',
            'totalPoints',
            'totalSales',
            'stores' // Passar as lojas para a view
        ));
    }
}

