<?php

namespace App\Http\Controllers\Architect;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point; // Certifique-se de que o modelo está importado
use App\Models\Ranking; // Importa o modelo de Ranking
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Show the architect dashboard.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // Obter o arquiteto logado
        $architect = Auth::user();

        // Obter o mês atual
        $currentMonth = Carbon::now()->month;

        // Obter o total de pontos no mês para o arquiteto logado
        $totalPointsThisMonth = Point::where('architect_id', $architect->id)
            ->whereMonth('created_at', $currentMonth)
            ->sum('points');

        // Obter o total de vendas no mês para o arquiteto logado
        $totalSalesThisMonth = Point::where('architect_id', $architect->id)
            ->whereMonth('created_at', $currentMonth)
            ->sum('sale_value');

        // Obter o número de vendas no mês para o arquiteto logado
        $numberOfSalesThisMonth = Point::where('architect_id', $architect->id)
            ->whereMonth('created_at', $currentMonth)
            ->count();

        // Obter o total de vendas e pontos no ano para o arquiteto logado
        $currentYear = Carbon::now()->year;
        $totalPointsThisYear = Point::where('architect_id', $architect->id)
            ->whereYear('created_at', $currentYear)
            ->sum('points');

        $totalSalesThisYear = Point::where('architect_id', $architect->id)
            ->whereYear('created_at', $currentYear)
            ->sum('sale_value');

        $numberOfSalesThisYear = Point::where('architect_id', $architect->id)
            ->whereYear('created_at', $currentYear)
            ->count();

        // Obter rankings ativos e válidos
        $activeRankings = Ranking::where('is_active', true)
            ->whereDate('start_date', '<=', Carbon::now())
            ->whereDate('end_date', '>=', Carbon::now())
            ->get();

        return view('architect.dashboard', compact(
            'totalPointsThisMonth', 
            'totalSalesThisMonth', 
            'numberOfSalesThisMonth', 
            'totalPointsThisYear', 
            'totalSalesThisYear', 
            'numberOfSalesThisYear', 
            'activeRankings'
        ));
    }
}
