<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth; // Para autenticar o usuário
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AdminRegistrationController extends Controller
{
    /**
     * Exibe o formulário de registro de admin.
     *
     * @return \Illuminate\View\View
     */
    public function showRegistrationForm()
    {
        return view('auth.register-admin');
    }

    /**
     * Processa o registro de um novo usuário admin e realiza login automático.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function register(Request $request)
    {
        // Valida os dados do formulário
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
        ]);

        // Cria o usuário admin
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'role' => 'admin', // Define o role como admin
        ]);

        // Autentica o usuário recém-criado
        Auth::login($user);

        // Redireciona o usuário para o painel de admin
        return redirect()->route('admin.dashboard')->with('success', 'Conta criada e você está logado!');
    }
}
